/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class IntStringHashMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry[] table;
    private transient int size;
    private int threshold;
    private float loadFactor;

    public IntStringHashMap(int initialCapacity, float loadFactor) {
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
    }

    public IntStringHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntStringHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    private static int getHash(int key) {
        return key;
    }

    private static int indexFor(int hash, int length) {
        return hash & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String get(int key) {
        int hash = IntStringHashMap.getHash(key);
        int i = IntStringHashMap.indexFor(hash, this.table.length);
        Entry entry = this.table[i];
        while (entry != null) {
            if (key == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    private Entry getEntry(int key) {
        int hash = IntStringHashMap.getHash(key);
        int i = IntStringHashMap.indexFor(hash, this.table.length);
        Entry entry = this.table[i];
        while (entry != null && key != entry.key) {
            entry = entry.next;
        }
        return entry;
    }

    public String put(int key, String value) {
        int hash = IntStringHashMap.getHash(key);
        int i = IntStringHashMap.indexFor(hash, this.table.length);
        Entry entry = this.table[i];
        while (entry != null) {
            if (key == entry.key) {
                String oldValue = entry.value;
                entry.value = value;
                return oldValue;
            }
            entry = entry.next;
        }
        this.table[i] = new Entry(key, value, this.table[i]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return null;
    }

    private void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    private void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            Entry entry = src[j];
            while (entry != null) {
                Entry next = entry.next;
                int i = IntStringHashMap.indexFor(entry.key, newCapacity);
                entry.next = newTable[i];
                newTable[i] = entry;
                entry = next;
            }
            ++j;
        }
    }

    public String remove(int key) {
        Entry previous;
        int hash = IntStringHashMap.getHash(key);
        int i = IntStringHashMap.indexFor(hash, this.table.length);
        Entry entry = previous = this.table[i];
        while (entry != null) {
            Entry next = entry.next;
            if (key == entry.key) {
                --this.size;
                if (previous == entry) {
                    this.table[i] = next;
                } else {
                    previous.next = next;
                }
                return entry.value;
            }
            previous = entry;
            entry = next;
        }
        return null;
    }

    public void clear() {
        int i = 0;
        while (i < this.table.length) {
            this.table[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public boolean containsValue(String value) {
        if (value == null) {
            return this.containsNullValue();
        }
        int i = 0;
        while (i < this.table.length) {
            Entry entry = this.table[i];
            while (entry != null) {
                if (value.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
            ++i;
        }
        return false;
    }

    private boolean containsNullValue() {
        int i = 0;
        while (i < this.table.length) {
            Entry entry = this.table[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
            ++i;
        }
        return false;
    }

    private static final class Entry {
        final int key;
        String value;
        Entry next;

        Entry(int key, String value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public int getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String setValue(String newValue) {
            String oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.key == entry.key && (this.value == entry.value || this.value != null && this.value.equals(entry.value));
        }

        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next = null;
        int index;
        Entry current;

        HashIterator() {
            this.index = IntStringHashMap.this.table.length;
            if (IntStringHashMap.this.size != 0) {
                while (this.index > 0 && (this.next = IntStringHashMap.this.table[--this.index]) == null) {
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Entry nextEntry() {
            this.current = this.next;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.next = this.current.next;
            while (this.next == null && this.index > 0) {
                this.next = IntStringHashMap.this.table[--this.index];
            }
            return this.current;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public abstract Object next();
    }

    private class ValueIterator
    extends HashIterator {
        ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends HashIterator {
        KeyIterator() {
        }

        public Object next() {
            return new Integer(this.nextEntry().key);
        }

        public int nextKey() {
            return this.nextEntry().key;
        }
    }
}

