/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import java.util.HashMap;

final class SearchCache {
    private static final String START_TAG_PREFIX = "ST";
    private static final String END_TAG_PREFIX = "ET";
    private static final String ELEMENT_PREFIX = "E";
    private static final String TAG_PREFIX = "T";
    private final HashMap cache = new HashMap();

    SearchCache() {
    }

    static String getStartTagKey(int n, String string, boolean bl) {
        if (string == Tag.SERVER_MASON_NAMED_BLOCK) {
            string = "%named>";
        }
        return SearchCache.getKey(START_TAG_PREFIX, n, string, bl);
    }

    StartTag getStartTag(String string) {
        return (StartTag)this.cache.get(string);
    }

    void setStartTag(String string, StartTag startTag) {
        this.cache.put(string, startTag == null ? StartTag.CACHED_NULL : startTag);
    }

    static String getEndTagKey(int n, String string, boolean bl) {
        return SearchCache.getKey(END_TAG_PREFIX, n, string, bl);
    }

    static String getEndTagKey(int n) {
        return ELEMENT_PREFIX + n;
    }

    EndTag getEndTag(String string) {
        return (EndTag)this.cache.get(string);
    }

    void setEndTag(String string, EndTag endTag) {
        this.cache.put(string, endTag == null ? EndTag.CACHED_NULL : endTag);
    }

    static String getElementKey(StartTag startTag) {
        return END_TAG_PREFIX + startTag.begin;
    }

    Element getElement(String string) {
        return (Element)this.cache.get(string);
    }

    void setElement(String string, Element element) {
        this.cache.put(string, element);
    }

    static String getTagKey(int n) {
        return TAG_PREFIX + n;
    }

    Tag getTag(String string) {
        return (Tag)this.cache.get(string);
    }

    void setTag(String string, Tag tag) {
        this.cache.put(string, tag == null ? Tag.CACHED_NULL : tag);
    }

    private static String getKey(String string, int n, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(n);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (bl) {
            stringBuffer.append('<');
        }
        return stringBuffer.toString();
    }
}

