/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.SpecialTag;
import au.id.jericho.lib.html.StartTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Segment {
    int begin;
    int end;
    Source source;
    private static final String WHITESPACE = " \n\r\t";

    public Segment(Source source, int n, int n2) {
        this(n, n2);
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.source = source;
    }

    Segment(int n, int n2) {
        if (n == -1 || n2 == -1 || n > n2) {
            throw new IllegalArgumentException();
        }
        this.begin = n;
        this.end = n2;
    }

    Segment() {
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)object;
        return segment.begin == this.begin && segment.end == this.end && segment.source == this.source;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    public final int length() {
        return this.end - this.begin;
    }

    public final boolean encloses(Segment segment) {
        return this.begin <= segment.begin && this.end >= segment.end;
    }

    public final boolean encloses(int n) {
        return this.begin <= n && n < this.end;
    }

    public boolean isComment() {
        return false;
    }

    public String getSourceText() {
        return this.source.getSourceText().substring(this.begin, this.end);
    }

    public final String getSourceTextNoWhitespace() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.begin;
        boolean bl = true;
        boolean bl2 = false;
        while (n < this.end) {
            char c = this.source.getSourceText().charAt(n++);
            bl2 = Segment.isWhiteSpace(c);
            if (bl2) {
                if (!bl) {
                    stringBuffer.append(' ');
                }
            } else {
                stringBuffer.append(c);
            }
            bl = bl2;
        }
        if (bl2) {
            stringBuffer.setLength(Math.max(0, stringBuffer.length() - 1));
        }
        return stringBuffer.toString();
    }

    public final List findWords() {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        int n = -1;
        for (int i = this.begin; i < this.end; ++i) {
            if (Segment.isWhiteSpace(this.source.getSourceText().charAt(i))) {
                if (n == -1) continue;
                arrayList.add(new Segment(this.source, n, i));
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n != -1) {
            arrayList.add(new Segment(this.source, n, this.end));
        }
        return arrayList;
    }

    public List findAllStartTags() {
        return this.findAllStartTags(null);
    }

    public List findAllStartTags(String string) {
        StartTag startTag;
        if (string != null) {
            string = string.toLowerCase();
        }
        if ((startTag = this.findNextStartTag(this.begin, string)) == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        do {
            arrayList.add(startTag);
        } while ((startTag = this.findNextStartTag(startTag.end, string)) != null);
        return arrayList;
    }

    public List findAllComments() {
        return this.findAllStartTags(SpecialTag.COMMENT.getName());
    }

    public List findAllElements() {
        return this.findAllElements(null);
    }

    public List findAllElements(String string) {
        List list;
        if (string != null) {
            string = string.toLowerCase();
        }
        if ((list = this.findAllStartTags(string)).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StartTag startTag = (StartTag)iterator.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            arrayList.add(element);
        }
        return arrayList;
    }

    public List findAllCharacterReferences() {
        CharacterReference characterReference = this.findNextCharacterReference(this.begin);
        if (characterReference == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CharacterReference> arrayList = new ArrayList<CharacterReference>();
        do {
            arrayList.add(characterReference);
        } while ((characterReference = this.findNextCharacterReference(characterReference.end)) != null);
        return arrayList;
    }

    public FormFields findFormFields() {
        return FormFields.construct(this);
    }

    public Attributes parseAttributes() {
        return this.source.parseAttributes(this.begin, this.end);
    }

    public void ignoreWhenParsing() {
        this.source.ignoreWhenParsing(this.begin, this.end);
    }

    public static final boolean isWhiteSpace(char c) {
        return WHITESPACE.indexOf(c) != -1;
    }

    public String toString() {
        return "(" + this.begin + ',' + this.end + ')';
    }

    static boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_' || c == ':';
    }

    static boolean isIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':';
    }

    private StartTag findNextStartTag(int n, String string) {
        StartTag startTag = this.source.findNextStartTag(n, string);
        if (startTag == null || startTag.end > this.end) {
            return null;
        }
        return startTag;
    }

    private CharacterReference findNextCharacterReference(int n) {
        CharacterReference characterReference = this.source.findNextCharacterReference(n);
        if (characterReference == null || characterReference.end > this.end) {
            return null;
        }
        return characterReference;
    }
}

