/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.geom.Point2D;
import org.stathissideris.ascii2image.graphics.ShapeEdge;

public class ShapePoint
extends Point2D.Float {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_ROUND = 1;
    private boolean locked = false;
    private int type = 0;

    public ShapePoint() {
    }

    public ShapePoint(float x, float y) {
        super(x, y);
        this.type = 0;
    }

    public ShapePoint(float x, float y, int type) {
        super(x, y);
        this.type = type;
    }

    public ShapePoint(ShapePoint other) {
        this(other.x, other.y, other.type);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int i) {
        this.type = i;
    }

    public boolean isInLineWith(ShapePoint point) {
        if (this.x == point.x) {
            return true;
        }
        return this.y == point.y;
    }

    public boolean isWithinEdge(ShapeEdge edge) {
        if (edge.isHorizontal()) {
            if (this.x >= edge.getStartPoint().x && this.x <= edge.getEndPoint().x) {
                return true;
            }
            return this.x >= edge.getEndPoint().x && this.x <= edge.getStartPoint().x;
        }
        if (edge.isVertical()) {
            if (this.y >= edge.getStartPoint().y && this.y <= edge.getEndPoint().y) {
                return true;
            }
            return this.y >= edge.getEndPoint().y && this.y <= edge.getStartPoint().y;
        }
        throw new RuntimeException("Cannot calculate is ShapePoint is within sloped edge");
    }

    public boolean isNorthOf(ShapePoint point) {
        return this.y < point.y;
    }

    public boolean isSouthOf(ShapePoint point) {
        return this.y > point.y;
    }

    public boolean isWestOf(ShapePoint point) {
        return this.x < point.x;
    }

    public boolean isEastOf(ShapePoint point) {
        return this.x > point.x;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public void assign(ShapePoint point) {
        this.x = point.x;
        this.y = point.y;
    }

    public void moveTo(ShapePoint point) {
        if (this.locked) {
            return;
        }
        this.x = point.x;
        this.y = point.y;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean b) {
        this.locked = b;
    }
}

