/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import com.sun.tools.doclets.standard.Standard;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class JavadocTaglet
implements Taglet {
    private static final String NAME = "textdiagram";
    private static final Pattern FIGURE_NAME_PATTERN = Pattern.compile("\\w+");
    private final File[] srcPath;
    private final File dstDir;
    private final boolean simpleMode;

    public JavadocTaglet() {
        String[] stringArray;
        String string = null;
        String string2 = null;
        try {
            stringArray = Standard.class.getField("htmlDoclet");
            Object object = stringArray.get(null);
            Method method = object.getClass().getMethod("configuration", null);
            Object object2 = method.invoke(object, null);
            Field field = object2.getClass().getField("sourcepath");
            string = (String)field.get(object2);
            Field field2 = object2.getClass().getField("destDirName");
            string2 = (String)field2.get(object2);
        }
        catch (Exception exception) {
            this.warning("Could not setup taglet. Falling back to simple mode.\n" + exception);
        }
        if (string2 == null) {
            this.srcPath = null;
            this.dstDir = null;
            this.simpleMode = true;
        } else {
            stringArray = string.split("[;:]");
            this.srcPath = new File[stringArray.length];
            for (int i = 0; i < this.srcPath.length; ++i) {
                this.srcPath[i] = new File(stringArray[i]).getAbsoluteFile();
                try {
                    this.srcPath[i] = this.srcPath[i].getCanonicalFile();
                    continue;
                }
                catch (IOException iOException) {
                    this.warning("Could not get canonical path of file: " + this.srcPath[i]);
                }
            }
            this.dstDir = new File(string2);
            this.simpleMode = false;
        }
    }

    public boolean inField() {
        return false;
    }

    public boolean inConstructor() {
        return false;
    }

    public boolean inMethod() {
        return false;
    }

    public boolean inOverview() {
        return false;
    }

    public boolean inPackage() {
        return false;
    }

    public boolean inType() {
        return false;
    }

    public boolean isInlineTag() {
        return true;
    }

    public String getName() {
        return NAME;
    }

    public String toString(Tag tag) {
        String string = tag.text().trim();
        int n = string.indexOf(" ");
        int n2 = string.indexOf("\n");
        if (n == -1) {
            // empty if block
        }
        int n3 = n == -1 || n == -1 ? Math.max(n, n2) : Math.min(n, n2);
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1);
        if (!FIGURE_NAME_PATTERN.matcher(string2).matches()) {
            this.error("Illegal " + this.getName() + " name: \"" + string2 + "\"");
        }
        string3 = string3.replaceAll("\\[(\\w+)\\]", "{$1}");
        if (this.simpleMode) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<pre>");
            stringBuffer.append(string3);
            stringBuffer.append("</pre>");
            return stringBuffer.toString();
        }
        File file = this.getOutputFile(tag.position().file(), string2);
        this.generateImage(string3, file);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<img src=\"");
        stringBuffer.append(file.getName());
        stringBuffer.append("\" alt=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\"/>");
        return stringBuffer.toString();
    }

    public String toString(Tag[] tagArray) {
        return null;
    }

    private File getOutputFile(File file, String string) {
        String string2 = this.getRelativePath(file);
        if (file.getName().toLowerCase().equals("overview.html") || string2 == null && file.getName().toLowerCase().endsWith(".html")) {
            string2 = "overview";
        }
        if (string2 == null) {
            this.error("The file is not relative to the source path: " + file);
        }
        String string3 = null;
        String string4 = null;
        int n = string2.lastIndexOf(File.separatorChar);
        if (n == -1) {
            string4 = string2;
        } else if (n == 0) {
            string4 = string2.substring(1);
        } else {
            string4 = string2.substring(n + 1);
            string3 = string2.substring(0, n);
        }
        n = string4.lastIndexOf(46);
        if (n != -1) {
            string4 = string4.substring(0, n);
        }
        String string5 = string3 == null ? string4 : string3 + File.separator + string4;
        return new File(this.dstDir, string5 + "-" + string + ".png");
    }

    private String getRelativePath(File file) {
        file = file.getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.warning("Could not get canonical path of file: " + file);
        }
        String string = file.getAbsolutePath();
        for (int i = 0; i < this.srcPath.length; ++i) {
            String string2 = this.srcPath[i].getAbsolutePath();
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).startsWith(File.separator)) {
                string = string.substring(1);
            }
            return string;
        }
        return null;
    }

    private void generateImage(String string, File file) {
        ConversionOptions conversionOptions = new ConversionOptions();
        TextGrid textGrid = new TextGrid();
        try {
            if (!textGrid.initialiseWithText(string, null)) {
                this.error("Cannot initialize text grid");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.error("Cannot initialize text grid");
        }
        Diagram diagram = new Diagram(textGrid, conversionOptions);
        RenderedImage renderedImage = new BitmapRenderer().renderToImage(diagram, conversionOptions.renderingOptions);
        try {
            ImageIO.write(renderedImage, "png", file);
        }
        catch (IOException iOException) {
            this.error("Cannot write to file " + file.getAbsolutePath());
        }
    }

    private void error(String string) {
        System.err.println("Error: " + string);
        System.exit(1);
    }

    private void warning(String string) {
        System.err.println("Warning: " + string);
    }

    public static void register(Map map) {
        JavadocTaglet javadocTaglet = new JavadocTaglet();
        map.put(javadocTaglet.getName(), javadocTaglet);
    }
}

