/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public abstract class DiagramComponent {
    private static final boolean DEBUG = false;

    protected static ShapePoint makePointForCell(TextGrid.Cell cell, TextGrid grid, int cellWidth, int cellHeight, boolean allRound) {
        if (grid.isCorner(cell) && allRound) {
            return new ShapePoint(cell.x * cellWidth + cellWidth / 2, cell.y * cellHeight + cellHeight / 2, 1);
        }
        if (grid.isNormalCorner(cell)) {
            return new ShapePoint(cell.x * cellWidth + cellWidth / 2, cell.y * cellHeight + cellHeight / 2, 0);
        }
        if (grid.isRoundCorner(cell)) {
            return new ShapePoint(cell.x * cellWidth + cellWidth / 2, cell.y * cellHeight + cellHeight / 2, 1);
        }
        if (grid.isLinesEnd(cell)) {
            return new ShapePoint(cell.x * cellWidth + cellWidth / 2, cell.y * cellHeight + cellHeight / 2, 0);
        }
        if (grid.isIntersection(cell)) {
            return new ShapePoint(cell.x * cellWidth + cellWidth / 2, cell.y * cellHeight + cellHeight / 2, 0);
        }
        throw new RuntimeException("Cannot make point for cell " + cell);
    }

    public static DiagramComponent createClosedFromBoundaryCells(TextGrid grid, CellSet cells, int cellWidth, int cellHeight) {
        return DiagramComponent.createClosedFromBoundaryCells(grid, cells, cellWidth, cellHeight, false);
    }

    public static DiagramComponent createClosedFromBoundaryCells(TextGrid grid, CellSet cells, int cellWidth, int cellHeight, boolean allRound) {
        if (cells.getType(grid) == 1) {
            throw new IllegalArgumentException("CellSet is closed and cannot be handled by this method");
        }
        if (cells.size() < 2) {
            return null;
        }
        DiagramShape shape = new DiagramShape();
        shape.setClosed(true);
        if (grid.containsAtLeastOneDashedLine(cells)) {
            shape.setStrokeDashed(true);
        }
        TextGrid workGrid = new TextGrid(grid.getWidth(), grid.getHeight());
        grid.copyCellsTo(cells, workGrid);
        TextGrid.Cell start = (TextGrid.Cell)cells.get(0);
        if (workGrid.isCorner(start)) {
            shape.addToPoints(DiagramComponent.makePointForCell(start, workGrid, cellWidth, cellHeight, allRound));
        }
        TextGrid.Cell previous = start;
        TextGrid.Cell cell = null;
        CellSet nextCells = workGrid.followCell(previous);
        if (nextCells.size() == 0) {
            return null;
        }
        cell = (TextGrid.Cell)nextCells.get(0);
        if (workGrid.isCorner(cell)) {
            shape.addToPoints(DiagramComponent.makePointForCell(cell, workGrid, cellWidth, cellHeight, allRound));
        }
        while (!cell.equals(start)) {
            nextCells = workGrid.followCell(cell, previous);
            if (nextCells.size() == 1) {
                previous = cell;
                cell = (TextGrid.Cell)nextCells.get(0);
                if (cell.equals(start) || !workGrid.isCorner(cell)) continue;
                shape.addToPoints(DiagramComponent.makePointForCell(cell, workGrid, cellWidth, cellHeight, allRound));
                continue;
            }
            if (nextCells.size() <= 1) continue;
            return null;
        }
        return shape;
    }
}

