/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.FormControlType;
import au.id.jericho.lib.html.SearchCache;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.SpecialTag;
import au.id.jericho.lib.html.Tag;
import java.util.Iterator;
import java.util.Set;

public final class StartTag
extends Tag {
    private Attributes attributes;
    private SpecialTag specialTag;
    static final StartTag CACHED_NULL = new StartTag();

    private StartTag(Source source, int begin, int end, String name, SpecialTag specialTag, Attributes attributes) {
        super(source, begin, end, name);
        this.attributes = attributes;
        this.specialTag = specialTag;
    }

    private StartTag() {
    }

    private static StartTag constructWithAttributes(Source source, int begin, String name, SpecialTag specialTag) {
        Attributes attributes = Attributes.construct(source, begin, name);
        if (attributes == null) {
            return null;
        }
        String lsource = source.getParseTextLowerCase();
        int end = attributes.end + (lsource.charAt(attributes.end) == '>' ? 1 : 2);
        if (name.equals(SpecialTag.COMMENT.getName())) {
            name = SpecialTag.COMMENT.getName();
        }
        StartTag startTag = new StartTag(source, begin, end, name, specialTag, attributes);
        return startTag;
    }

    public boolean isEndTagForbidden() {
        return this.isEmptyElementTag() || this.specialTag != null && !this.specialTag.hasEndTag() || Tag.isEndTagForbidden(this.name);
    }

    public boolean isEndTagOptional() {
        return Tag.isEndTagOptional(this.name);
    }

    public boolean isEndTagRequired() {
        return Tag.isEndTagRequired(this.name);
    }

    public boolean isEmptyElementTag() {
        return this.source.getSourceText().charAt(this.end - 2) == '/';
    }

    public boolean isComment() {
        return this.specialTag == SpecialTag.COMMENT;
    }

    public boolean isProcessingInstruction() {
        return this.name.charAt(0) == '?';
    }

    public boolean isXMLDeclaration() {
        return this.name == "?xml";
    }

    public boolean isDocTypeDeclaration() {
        return this.name == "!doctype";
    }

    public boolean isServerTag() {
        return this.specialTag != null && this.specialTag.isServerTag();
    }

    public boolean isPHPTag() {
        return this.specialTag == SpecialTag.PHP_TAG;
    }

    public boolean isCommonServerTag() {
        return this.specialTag == SpecialTag.COMMON_SERVER_TAG;
    }

    public boolean isMasonTag() {
        return this.isCommonServerTag() || this.isMasonNamedBlock() || this.isMasonComponentCall() || this.isMasonComponentCalledWithContent();
    }

    public boolean isMasonNamedBlock() {
        return this.specialTag == SpecialTag.MASON_NAMED_BLOCK;
    }

    public boolean isMasonComponentCall() {
        return this.specialTag == SpecialTag.MASON_COMPONENT_CALL;
    }

    public boolean isMasonComponentCalledWithContent() {
        return this.specialTag == SpecialTag.MASON_COMPONENT_CALLED_WITH_CONTENT;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int maxErrorCount) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int maxEnd = this.end - (this.specialTag != null ? this.specialTag.getEndDelimiter().length() : 1);
        int attributesBegin = this.begin + 1 + this.name.length();
        while (!Segment.isIdentifierStart(this.source.getSourceText().charAt(attributesBegin))) {
            if (++attributesBegin != maxEnd) continue;
            return null;
        }
        return Attributes.construct(this.source, this.begin, attributesBegin, maxEnd, this.name, maxErrorCount);
    }

    public FormControlType getFormControlType() {
        if (this.isComment() || !FormControlType.isPotentialControl(this.name)) {
            return null;
        }
        if (this.name.equals("textarea")) {
            return FormControlType.TEXTAREA;
        }
        Attributes attributes = this.getAttributes();
        if (this.name.equals("select")) {
            Attribute multiple = attributes.get("multiple");
            return multiple != null ? FormControlType.SELECT_MULTIPLE : FormControlType.SELECT_SINGLE;
        }
        Attribute type = attributes.get("type");
        if (this.name.equals("button")) {
            return type == null || type.getValue().equalsIgnoreCase("submit") ? FormControlType.BUTTON : null;
        }
        if (type == null) {
            return FormControlType.TEXT;
        }
        return FormControlType.get(type.getValue().toLowerCase());
    }

    public Segment getFollowingTextSegment() {
        int endData = this.source.getParseTextLowerCase().indexOf(60, this.end);
        if (endData == -1) {
            endData = this.source.length();
        }
        return new Segment(this.source, this.end, endData);
    }

    public EndTag findEndTag() {
        return this.getElement().getEndTag();
    }

    public Element getElement() {
        String cacheKey = SearchCache.getElementKey(this);
        Element element = this.source.getSearchCache().getElement(cacheKey);
        if (element == null) {
            element = new Element(this.source, this, this.findEndTagInternal());
            this.source.getSearchCache().setElement(cacheKey, element);
        }
        return element;
    }

    private EndTag findEndTagInternal() {
        if (this.isEndTagForbidden()) {
            return null;
        }
        Tag.TerminatorSets terminatorSets = this.getOptionalEndTagTerminatorSets();
        if (terminatorSets != null) {
            return this.findOptionalEndTag(terminatorSets);
        }
        String endTagName = this.name == "&|" ? "&" : this.name;
        Segment[] findResult = this.findEndTag(this.source.getParseTextLowerCase(), this.source.findNextEndTag(this.end, endTagName));
        if (findResult == null) {
            return null;
        }
        return (EndTag)findResult[0];
    }

    public String toString() {
        if (this == CACHED_NULL) {
            return "CACHED_NULL";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\"').append(this.name).append("\" ");
        if (this.specialTag != null) {
            sb.append('(').append(this.specialTag.getDescription()).append(") ");
        }
        sb.append(super.toString());
        return sb.toString();
    }

    private EndTag findOptionalEndTag(Tag.TerminatorSets terminatorSets) {
        Iterator i = this.source.getNextTagIterator(this.end);
        while (i.hasNext()) {
            Set terminatorSet;
            Tag tag = (Tag)i.next();
            if (tag instanceof EndTag) {
                if (tag.name.equals(this.name)) {
                    return (EndTag)tag;
                }
                terminatorSet = terminatorSets.getEndTagTerminatorSet();
            } else {
                terminatorSet = terminatorSets.getIgnoredNestedElementSet();
                if (terminatorSet != null && terminatorSet.contains(tag.name)) {
                    Element ignoredNestedElement = ((StartTag)tag).getElement();
                    i = this.source.getNextTagIterator(ignoredNestedElement.end);
                    continue;
                }
                terminatorSet = terminatorSets.getStartTagTerminatorSet();
            }
            if (terminatorSet == null || !terminatorSet.contains(tag.name)) continue;
            return new EndTag(this.source, tag.begin, tag.begin, this.name);
        }
        return new EndTag(this.source, this.source.end, this.source.end, this.name);
    }

    static StartTag findPreviousOrNext(Source source, int pos, String name, boolean previous) {
        String cacheKey = SearchCache.getStartTagKey(pos, name, previous);
        StartTag startTag = source.getSearchCache().getStartTag(cacheKey);
        if (startTag == null) {
            Tag tag = source.getSearchCache().getTag(SearchCache.getTagKey(pos));
            if (tag instanceof StartTag && (name == null || name.equals(tag.name))) {
                return (StartTag)tag;
            }
            startTag = StartTag.findPreviousOrNextUncached(source, pos, name, previous);
            source.getSearchCache().setStartTag(cacheKey, startTag);
            if (startTag != null && name == null) {
                source.getSearchCache().setStartTag(SearchCache.getStartTagKey(pos, startTag.name, previous), startTag);
            }
        }
        return startTag == CACHED_NULL ? null : startTag;
    }

    private static StartTag findPreviousOrNextUncached(Source source, int pos, String searchName, boolean previous) {
        String startDelimiter;
        SpecialTag searchSpecialTag;
        if (searchName == null) {
            return StartTag.findPreviousOrNext(source, pos, previous);
        }
        boolean namespaceSearch = searchName.charAt(searchName.length() - 1) == ':';
        SpecialTag specialTag = searchSpecialTag = namespaceSearch ? null : SpecialTag.get(searchName);
        if (searchSpecialTag != null) {
            searchName = searchSpecialTag.getName();
            startDelimiter = searchSpecialTag.getStartDelimiter();
        } else {
            searchName = searchName.toLowerCase();
            startDelimiter = String.valueOf('<') + searchName;
        }
        try {
            String lsource = source.getParseTextLowerCase();
            int begin = pos;
            do {
                int nameEnd;
                int n = begin = previous ? lsource.lastIndexOf(startDelimiter, begin) : lsource.indexOf(startDelimiter, begin);
                if (begin == -1) {
                    return null;
                }
                Segment enclosingComment = source.findEnclosingComment(begin - 1);
                if (enclosingComment != null) {
                    if (searchSpecialTag == SpecialTag.COMMENT && previous) {
                        return (StartTag)enclosingComment;
                    }
                    begin = previous ? enclosingComment.begin - 2 : enclosingComment.end;
                    continue;
                }
                int searchNameEnd = begin + startDelimiter.length();
                SpecialTag specialTag2 = searchSpecialTag;
                String name = searchName;
                if (searchSpecialTag == SpecialTag.COMMENT) {
                    nameEnd = searchNameEnd;
                } else {
                    nameEnd = source.getIdentifierEnd(searchNameEnd, false);
                    if (nameEnd == -1) {
                        nameEnd = searchNameEnd;
                    } else if (nameEnd != searchNameEnd) {
                        if (namespaceSearch) {
                            name = lsource.substring(begin + 1, nameEnd);
                        } else {
                            if (specialTag2 == null || !specialTag2.isIdentifierCharacterAllowedAfterName()) continue;
                            name = lsource.substring(begin + 1, nameEnd);
                            specialTag2 = SpecialTag.get(name);
                            if (specialTag2 == null) {
                                specialTag2 = searchSpecialTag;
                            } else {
                                name = specialTag2.getName();
                            }
                        }
                    }
                }
                if (specialTag2 != null && specialTag2 != SpecialTag.XML_DECLARATION) {
                    EndTag endTag;
                    int masonNamedBlockEnd;
                    int end = source.findEnd(nameEnd, specialTag2);
                    if (specialTag2 == SpecialTag.COMMON_SERVER_TAG && nameEnd != searchNameEnd && (masonNamedBlockEnd = source.findEnd(nameEnd, SpecialTag.MASON_NAMED_BLOCK)) != -1 && (end == -1 || masonNamedBlockEnd < end) && (endTag = source.findNextEndTag(masonNamedBlockEnd, name)) != null) {
                        return new StartTag(source, begin, masonNamedBlockEnd, name, SpecialTag.MASON_NAMED_BLOCK, null);
                    }
                    if (end == -1) {
                        source.log("StartTag", name, begin, "rejected because it has no matching end delimiter", -1);
                        if (!previous) {
                            return null;
                        }
                        begin -= 4;
                        continue;
                    }
                    if (specialTag2 == SpecialTag.MASON_NAMED_BLOCK) {
                        EndTag endTag2;
                        if (nameEnd == searchNameEnd || lsource.charAt(end - 2) == '%' || (endTag2 = source.findNextEndTag(end, name)) == null) {
                            continue;
                        }
                    } else if (specialTag2 == SpecialTag.MASON_COMPONENT_CALL && lsource.charAt(nameEnd) == '|') {
                        specialTag2 = SpecialTag.MASON_COMPONENT_CALLED_WITH_CONTENT;
                        name = specialTag2.getName();
                    }
                    return new StartTag(source, begin, end, name, specialTag2, null);
                }
                StartTag startTag = StartTag.constructWithAttributes(source, begin, name, specialTag2);
                if (startTag == null) continue;
                return startTag;
            } while (StartTag.inRange(source, begin = previous ? begin - 2 : begin + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StartTag findPreviousOrNext(Source source, int pos, boolean previous) {
        try {
            StartTag previousComment = source.findPreviousStartTag(pos, SpecialTag.COMMENT.getName());
            if (previousComment != null) {
                if (previousComment.end > pos) {
                    if (previous) {
                        return previousComment;
                    }
                    pos = previousComment.end;
                }
                if (!previous) {
                    previousComment = null;
                }
            }
            String lsource = source.getParseTextLowerCase();
            int begin = pos;
            do {
                Object var13_14;
                StartTag startTag;
                String tagAtCacheKey;
                block16: {
                    StartTag startTag2;
                    block17: {
                        block15: {
                            int n = begin = previous ? lsource.lastIndexOf(60, begin) : lsource.indexOf(60, begin);
                            if (begin == -1) {
                                return null;
                            }
                            if (previousComment != null && previousComment.encloses(begin)) {
                                return previousComment;
                            }
                            tagAtCacheKey = SearchCache.getTagKey(begin);
                            Tag tag = source.getSearchCache().getTag(tagAtCacheKey);
                            if (tag instanceof StartTag) {
                                return (StartTag)tag;
                            }
                            if (tag != null || lsource.charAt(begin + 1) == '/') continue;
                            int nameBegin = begin + 1;
                            String name = null;
                            startTag = null;
                            SpecialTag specialTag = SpecialTag.get(source, nameBegin);
                            try {
                                if (specialTag != null) {
                                    startTag = StartTag.newSpecialStartTag(source, begin, nameBegin, specialTag);
                                    if (startTag != null) {
                                        StartTag startTag3 = startTag;
                                        var13_14 = null;
                                        source.getSearchCache().setTag(tagAtCacheKey, startTag);
                                        return startTag3;
                                    }
                                    var13_14 = null;
                                    source.getSearchCache().setTag(tagAtCacheKey, startTag);
                                    continue;
                                }
                                int nameEnd = source.getIdentifierEnd(nameBegin, true);
                                if (nameEnd == -1) {
                                    source.log("StartTag", null, begin, "rejected because it has an invalid first character in its name", -1);
                                    break block15;
                                }
                                name = lsource.substring(nameBegin, nameEnd);
                                startTag = StartTag.constructWithAttributes(source, begin, name, null);
                                if (startTag == null) break block16;
                                startTag2 = startTag;
                                break block17;
                            }
                            catch (Throwable throwable) {
                                var13_14 = null;
                                source.getSearchCache().setTag(tagAtCacheKey, startTag);
                                throw throwable;
                            }
                        }
                        var13_14 = null;
                        source.getSearchCache().setTag(tagAtCacheKey, startTag);
                        continue;
                    }
                    var13_14 = null;
                    source.getSearchCache().setTag(tagAtCacheKey, startTag);
                    return startTag2;
                }
                var13_14 = null;
                source.getSearchCache().setTag(tagAtCacheKey, startTag);
            } while (StartTag.inRange(source, begin += previous ? -2 : 2));
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    private static StartTag newSpecialStartTag(Source source, int begin, int nameBegin, SpecialTag specialTag) {
        String name;
        int nameEnd;
        int end = -1;
        String lsource = source.getParseTextLowerCase();
        if (specialTag == SpecialTag.COMMON_SERVER_TAG && (nameEnd = source.getIdentifierEnd(nameBegin + 1, true)) != -1) {
            name = lsource.substring(nameBegin, nameEnd);
            end = source.findEnd(nameEnd, SpecialTag.MASON_NAMED_BLOCK);
            if (end == -1) {
                source.log("StartTag", specialTag.getName(), begin, "rejected because it has no matching end delimiter", -1);
                return null;
            }
            EndTag endTag = source.findNextEndTag(end, name);
            if (endTag != null) {
                return new StartTag(source, begin, end, name, SpecialTag.MASON_NAMED_BLOCK, null);
            }
        }
        if ((end = source.findEnd(nameBegin + 1, specialTag)) == -1) {
            source.log("StartTag", specialTag.getName(), begin, "rejected because it has no matching end delimiter", -1);
            return null;
        }
        name = specialTag.getName();
        if (specialTag == SpecialTag.XML_DECLARATION) {
            return StartTag.constructWithAttributes(source, begin, name, specialTag);
        }
        return new StartTag(source, begin, end, name, specialTag, null);
    }

    private static boolean inRange(Source source, int pos) {
        return pos >= 0 && pos <= source.length();
    }

    private Segment[] findEndTag(String lsource, EndTag nextEndTag) {
        return this.findEndTag(lsource, this.end, this.source.findNextStartTag(this.end, this.name), nextEndTag);
    }

    private Segment[] findEndTag(String lsource, int afterPos, StartTag nextStartTag, EndTag nextEndTag) {
        if (nextEndTag == null) {
            return null;
        }
        Segment[] returnArray = new Segment[]{nextEndTag, nextStartTag};
        if (nextStartTag == null || nextStartTag.begin > nextEndTag.begin) {
            return returnArray;
        }
        Segment[] findResult = nextStartTag.findEndTag(lsource, nextEndTag);
        if (findResult == null) {
            return null;
        }
        EndTag nextStartTagsEndTag = (EndTag)findResult[0];
        nextStartTag = (StartTag)findResult[1];
        nextEndTag = this.source.findNextEndTag(nextStartTagsEndTag.end, this.name);
        return this.findEndTag(lsource, nextStartTagsEndTag.end, nextStartTag, nextEndTag);
    }
}

