/*
 * Decompiled with CFR 0.152.
 */
package jargs.examples.gnu;

import jargs.gnu.CmdLineParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class CustomOptionTest {
    private static void printUsage() {
        System.err.println("usage: prog [{-d,--date} date]");
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option date = parser.addOption(new ShortDateOption('d', "date"));
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            CustomOptionTest.printUsage();
            System.exit(2);
        }
        Date dateValue = (Date)parser.getOptionValue(date);
        System.out.println("date: " + dateValue);
        String[] otherArgs = parser.getRemainingArgs();
        System.out.println("remaining args: ");
        int i = 0;
        while (i < otherArgs.length) {
            System.out.println(otherArgs[i]);
            ++i;
        }
        System.exit(0);
    }

    public static class ShortDateOption
    extends CmdLineParser.Option {
        public ShortDateOption(char shortForm, String longForm) {
            super(shortForm, longForm, true);
        }

        protected Object parseValue(String arg, Locale locale) throws CmdLineParser.IllegalOptionValueException {
            try {
                DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
                return dateFormat.parse(arg);
            }
            catch (ParseException e) {
                throw new CmdLineParser.IllegalOptionValueException(this, arg);
            }
        }
    }
}

