/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Tag;
import java.util.HashMap;

final class SpecialTag {
    private String description;
    private String name;
    private String startDelimiter;
    private String endDelimiter;
    private boolean serverTag;
    private boolean hasEndTag;
    private boolean identifierCharacterAllowedAfterName;
    public static final SpecialTag COMMENT = new SpecialTag("comment", "!--", "<!--", "-->", false, false);
    public static final SpecialTag DOCTYPE = new SpecialTag("document type declaration", "!doctype", "<!doctype", ">", false, false);
    public static final SpecialTag PROCESSING_INSTRUCTION = new SpecialTag("processing instruction", "?", "<?", "?>", false, false);
    public static final SpecialTag XML_DECLARATION = new SpecialTag("XML declaration", "?xml", "<?xml", "?>", false, false);
    public static final SpecialTag PHP_TAG = new SpecialTag("PHP tag", "?php", "<?php", "?>", true, false);
    public static final SpecialTag COMMON_SERVER_TAG = new SpecialTag("common server tag", Tag.SERVER_COMMON, "<%", "%>", true, false);
    public static final SpecialTag MASON_COMPONENT_CALL = new SpecialTag("mason component call", "&", "<&", "&>", true, false);
    public static final SpecialTag MASON_COMPONENT_CALLED_WITH_CONTENT = new SpecialTag("mason component called with content", "&|", "<&|", "&>", true, true);
    public static final SpecialTag MASON_NAMED_BLOCK = new SpecialTag("mason named block", Tag.SERVER_MASON_NAMED_BLOCK, "<%", ">", true, true);
    private static SpecialTag[] mappedSpecialTags = new SpecialTag[]{COMMENT, DOCTYPE, PROCESSING_INSTRUCTION, XML_DECLARATION, PHP_TAG, COMMON_SERVER_TAG, MASON_COMPONENT_CALL, MASON_COMPONENT_CALLED_WITH_CONTENT};
    private static HashMap map = new HashMap();

    static {
        int i = 0;
        while (i < mappedSpecialTags.length) {
            map.put(SpecialTag.mappedSpecialTags[i].name, mappedSpecialTags[i]);
            ++i;
        }
    }

    private SpecialTag(String description, String name, String startDelimiter, String endDelimiter, boolean serverTag, boolean hasEndTag) {
        this.description = description;
        this.name = name;
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.serverTag = serverTag;
        this.hasEndTag = hasEndTag;
        this.identifierCharacterAllowedAfterName = !Character.isLetter(name.charAt(name.length() - 1));
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public boolean isServerTag() {
        return this.serverTag;
    }

    public boolean hasEndTag() {
        return this.hasEndTag;
    }

    public boolean isIdentifierCharacterAllowedAfterName() {
        return this.identifierCharacterAllowedAfterName;
    }

    public static SpecialTag get(String name) {
        if (name == SpecialTag.MASON_NAMED_BLOCK.name) {
            return MASON_NAMED_BLOCK;
        }
        return (SpecialTag)map.get(name.toLowerCase());
    }

    public static SpecialTag get(Source source, int pos) {
        String lsource = source.getParseTextLowerCase();
        char firstChar = lsource.charAt(pos);
        switch (firstChar) {
            case '!': {
                if (lsource.startsWith(COMMENT.getName(), pos)) {
                    return COMMENT;
                }
                if (lsource.startsWith("!doctype", pos)) {
                    return DOCTYPE;
                }
                return null;
            }
            case '?': {
                if (lsource.startsWith("?xml", pos)) {
                    return XML_DECLARATION;
                }
                if (lsource.startsWith("?php", pos)) {
                    return PHP_TAG;
                }
                return PROCESSING_INSTRUCTION;
            }
            case '%': {
                return COMMON_SERVER_TAG;
            }
            case '&': {
                if (lsource.charAt(pos + 1) == '|') {
                    return MASON_COMPONENT_CALLED_WITH_CONTENT;
                }
                return MASON_COMPONENT_CALL;
            }
        }
        return null;
    }
}

