/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public class CompositeDiagramShape
extends DiagramComponent {
    private static final boolean DEBUG = false;
    private ArrayList shapes = new ArrayList();

    public static void main(String[] args) {
    }

    public static DiagramComponent createFromBoundaryCells(TextGrid grid, CellSet boundaryCells, int cellWidth, int cellHeight) {
        return CompositeDiagramShape.createOpenFromBoundaryCells(grid, boundaryCells, cellWidth, cellHeight, false);
    }

    public static DiagramComponent createOpenFromBoundaryCells(TextGrid grid, CellSet boundaryCells, int cellWidth, int cellHeight, boolean allRound) {
        if (boundaryCells.getType(grid) != 1) {
            throw new IllegalArgumentException("This shape is closed and cannot be handled by this method");
        }
        if (boundaryCells.size() == 0) {
            return null;
        }
        CompositeDiagramShape result = new CompositeDiagramShape();
        TextGrid workGrid = new TextGrid(grid.getWidth(), grid.getHeight());
        grid.copyCellsTo(boundaryCells, workGrid);
        CellSet visitedEnds = new CellSet();
        Iterator it = ((AbstractList)boundaryCells).iterator();
        while (it.hasNext()) {
            TextGrid.Cell start = (TextGrid.Cell)it.next();
            if (!workGrid.isLinesEnd(start) || visitedEnds.contains(start)) continue;
            DiagramShape s = new DiagramShape();
            if (workGrid.isPointCell(start)) {
                s.addToPoints(DiagramComponent.makePointForCell(start, workGrid, cellWidth, cellHeight, allRound));
            }
            if (workGrid.cellContainsDashedLineChar(start)) {
                s.setStrokeDashed(true);
            }
            TextGrid.Cell previous = start;
            TextGrid.Cell cell = null;
            CellSet nextCells = workGrid.followCell(previous);
            if (nextCells.size() == 0) {
                throw new IllegalArgumentException("This shape is either open but multipart or has only one cell, and cannot be processed by this method");
            }
            cell = (TextGrid.Cell)nextCells.get(0);
            if (workGrid.cellContainsDashedLineChar(cell)) {
                s.setStrokeDashed(true);
            }
            if (workGrid.isPointCell(cell)) {
                s.addToPoints(DiagramComponent.makePointForCell(cell, workGrid, cellWidth, cellHeight, allRound));
            }
            boolean finished = false;
            if (workGrid.isLinesEnd(cell)) {
                visitedEnds.add(cell);
                finished = true;
            }
            while (!finished) {
                nextCells = workGrid.followCell(cell, previous);
                if (nextCells.size() == 1) {
                    previous = cell;
                    cell = (TextGrid.Cell)nextCells.get(0);
                    if (workGrid.cellContainsDashedLineChar(cell)) {
                        s.setStrokeDashed(true);
                    }
                    if (!cell.equals(start) && workGrid.isPointCell(cell)) {
                        s.addToPoints(DiagramComponent.makePointForCell(cell, workGrid, cellWidth, cellHeight, allRound));
                    }
                    if (!workGrid.isLinesEnd(cell)) continue;
                    visitedEnds.add(cell);
                    finished = true;
                    continue;
                }
                if (nextCells.size() <= 1) continue;
                finished = true;
            }
            if (s.getPoints().size() <= 1) continue;
            result.addToShapes(s);
        }
        if (result.getShapes().size() == 1) {
            return (DiagramShape)result.getShapes().get(0);
        }
        return result;
    }

    public DiagramComponent connectLines() {
        CompositeDiagramShape result = new CompositeDiagramShape();
        ArrayList<DiagramShape> lines = new ArrayList<DiagramShape>();
        Iterator it = ((AbstractList)this.shapes).iterator();
        while (it.hasNext()) {
            DiagramShape shape = (DiagramShape)it.next();
            if (shape.getPoints().size() != 2) continue;
            lines.add(shape);
        }
        it = ((AbstractList)lines).iterator();
        while (it.hasNext()) {
            DiagramShape line1 = (DiagramShape)it.next();
            Iterator it2 = ((AbstractList)lines).iterator();
            while (it2.hasNext()) {
                DiagramShape line2 = (DiagramShape)it.next();
                ShapePoint commonPoint = null;
                ShapePoint line1UncommonPoint = null;
                ShapePoint line2UncommonPoint = null;
                if (line1.getPoint(0).equals(line2.getPoint(0))) {
                    commonPoint = line1.getPoint(0);
                    line1UncommonPoint = line1.getPoint(1);
                    line2UncommonPoint = line2.getPoint(1);
                }
                if (line1.getPoint(0).equals(line2.getPoint(1))) {
                    commonPoint = line1.getPoint(0);
                    line1UncommonPoint = line1.getPoint(1);
                    line2UncommonPoint = line2.getPoint(0);
                }
                if (line1.getPoint(1).equals(line2.getPoint(0))) {
                    commonPoint = line1.getPoint(1);
                    line1UncommonPoint = line1.getPoint(0);
                    line2UncommonPoint = line2.getPoint(1);
                }
                if (!line1.getPoint(1).equals(line2.getPoint(1))) continue;
                commonPoint = line1.getPoint(1);
                line1UncommonPoint = line1.getPoint(0);
                line2UncommonPoint = line2.getPoint(0);
            }
        }
        return result;
    }

    public void connectEndsToAnchors(TextGrid grid, Diagram diagram) {
        Iterator it = ((AbstractList)this.shapes).iterator();
        while (it.hasNext()) {
            DiagramShape shape = (DiagramShape)it.next();
            if (shape.isClosed()) continue;
            shape.connectEndsToAnchors(grid, diagram);
        }
    }

    private static DiagramShape makeLine(TextGrid grid, TextGrid.Cell start, TextGrid.Cell end, int cellWidth, int cellHeight) {
        int type;
        DiagramShape line = new DiagramShape();
        if (grid.isHorizontalLine(start)) {
            if (start.isWestOf(end)) {
                line.addToPoints(new ShapePoint(Diagram.getCellMinX(start, cellWidth), Diagram.getCellMidY(start, cellHeight)));
            } else {
                line.addToPoints(new ShapePoint(Diagram.getCellMaxX(start, cellWidth), Diagram.getCellMidY(start, cellHeight)));
            }
        } else if (grid.isVerticalLine(start)) {
            if (start.isNorthOf(end)) {
                line.addToPoints(new ShapePoint(Diagram.getCellMidX(start, cellWidth), Diagram.getCellMinY(start, cellHeight)));
            } else {
                line.addToPoints(new ShapePoint(Diagram.getCellMidX(start, cellWidth), Diagram.getCellMaxY(start, cellHeight)));
            }
        } else {
            type = grid.isRoundCorner(start) ? 1 : 0;
            line.addToPoints(new ShapePoint(Diagram.getCellMidX(start, cellWidth), Diagram.getCellMidY(start, cellHeight), type));
        }
        if (grid.isHorizontalLine(end)) {
            if (start.isWestOf(start)) {
                line.addToPoints(new ShapePoint(Diagram.getCellMinX(end, cellWidth), Diagram.getCellMidY(end, cellHeight)));
            } else {
                line.addToPoints(new ShapePoint(Diagram.getCellMaxX(end, cellWidth), Diagram.getCellMidY(end, cellHeight)));
            }
        } else if (grid.isVerticalLine(end)) {
            if (start.isNorthOf(start)) {
                line.addToPoints(new ShapePoint(Diagram.getCellMidX(end, cellWidth), Diagram.getCellMinY(end, cellHeight)));
            } else {
                line.addToPoints(new ShapePoint(Diagram.getCellMidX(end, cellWidth), Diagram.getCellMaxY(end, cellHeight)));
            }
        } else {
            type = grid.isRoundCorner(end) ? 1 : 0;
            line.addToPoints(new ShapePoint(Diagram.getCellMidX(end, cellWidth), Diagram.getCellMidY(end, cellHeight), type));
        }
        return line;
    }

    public void addToShapes(DiagramShape shape) {
        this.shapes.add(shape);
    }

    private Iterator getShapesIterator() {
        return ((AbstractList)this.shapes).iterator();
    }

    public void scale(float factor) {
        Iterator it = this.getShapesIterator();
        while (it.hasNext()) {
            DiagramShape shape = (DiagramShape)it.next();
            shape.scale(factor);
        }
    }

    public ArrayList getShapes() {
        return this.shapes;
    }
}

