/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StringOutputSegment;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.text.html.HTMLEditorKit;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class HTMLConverter
extends HTMLEditorKit {
    private static final String TAG_CLASS = "textdiagram";

    public static void main(String[] args) {
        new HTMLConverter().convertHTMLFile("index.html", "index2.html", "ditaa_diagram", "images", null);
    }

    public boolean convertHTMLFile(String filename, String targetFilename, String imageBaseFilename, String imageDirName, ConversionOptions options) {
        File imageDir;
        if (options == null) {
            options = new ConversionOptions();
        }
        if (!(imageDir = new File(imageDirName)).exists() && !imageDir.mkdir()) {
            System.err.println("Could not create directory " + imageDirName);
            return false;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: cannot read file " + filename);
            return false;
        }
        String htmlText = "";
        try {
            while (in.ready()) {
                htmlText = String.valueOf(htmlText) + in.readLine() + "\n";
            }
            in.close();
        }
        catch (IOException e1) {
            System.err.println("Error while reading file " + filename);
            return false;
        }
        System.out.print("Convering HTML file (" + filename + " -> " + targetFilename + ")... ");
        Source source = new Source(htmlText);
        OutputDocument outputDocument = new OutputDocument(htmlText);
        int index = 1;
        HashMap<String, String> diagramList = new HashMap<String, String>();
        List linkStartTags = source.findAllElements("pre");
        Iterator<Object> it = linkStartTags.iterator();
        while (it.hasNext()) {
            String URL2;
            Element element = (Element)it.next();
            StartTag tag = element.getStartTag();
            Attribute classAttr = tag.getAttributes().get("class");
            if (classAttr == null || !classAttr.hasValue() || !classAttr.getValue().equals(TAG_CLASS)) continue;
            String baseFilename = imageBaseFilename;
            Attribute nameAttr = tag.getAttributes().get("id");
            if (nameAttr != null && nameAttr.hasValue()) {
                baseFilename = this.makeFilenameFromTagName(nameAttr.getValue());
                URL2 = String.valueOf(imageDirName) + "/" + baseFilename + ".png";
            } else {
                URL2 = String.valueOf(imageDirName) + "/" + baseFilename + "_" + index + ".png";
                ++index;
            }
            outputDocument.add(new StringOutputSegment(element, "<img src=\"" + URL2 + "\" />"));
            diagramList.put(URL2, element.getContent().getSourceText());
        }
        if (diagramList.isEmpty()) {
            System.out.println("\nHTML document does not contain any <pre> tags with their class attribute set to \"textdiagram\". Nothing to do.");
            System.exit(0);
        }
        try {
            FileWriter out = new FileWriter(targetFilename);
            outputDocument.output(out);
        }
        catch (IOException e2) {
            System.err.println("Error while writing to file " + targetFilename);
            return false;
        }
        System.out.println("done");
        System.out.println("Generating diagrams... ");
        it = diagramList.keySet().iterator();
        while (it.hasNext()) {
            String URL3 = (String)it.next();
            String text = (String)diagramList.get(URL3);
            if (new File(URL3).exists() && !options.processingOptions.overwriteFiles()) {
                System.out.println("Error: Cannot overwrite to file " + URL3 + ", file already exists." + " Use the --overwrite option if you would like to allow file overwrite.");
                continue;
            }
            TextGrid grid = new TextGrid();
            grid.initialiseWithText(text, options.processingOptions);
            Diagram diagram = new Diagram(grid, options);
            RenderedImage image = BitmapRenderer.renderToImage(diagram, options.renderingOptions);
            try {
                File file = new File(URL3);
                ImageIO.write(image, "png", file);
            }
            catch (IOException e) {
                System.err.println("Error: Cannot write to file " + filename + " -- skipping");
                continue;
            }
            System.out.println("\t" + URL3);
        }
        System.out.println("\n...done");
        return true;
    }

    private String makeFilenameFromTagName(String tagName) {
        tagName = tagName.replace(' ', '_');
        return tagName;
    }
}

