/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;

public final class Element
extends Segment {
    private StartTag startTag;
    private EndTag endTag = null;

    Element(Source source, StartTag startTag, EndTag endTag) {
        super(source, startTag.begin, endTag == null ? startTag.end : endTag.end);
        this.startTag = startTag;
        this.endTag = endTag == null || endTag.length() == 0 ? null : endTag;
    }

    public String getContentText() {
        return this.isEmpty() ? null : this.source.getSourceText().substring(this.startTag.end, this.getContentEnd());
    }

    public Segment getContent() {
        return this.isEmpty() ? null : new Segment(this.source, this.startTag.end, this.getContentEnd());
    }

    public StartTag getStartTag() {
        return this.startTag;
    }

    public EndTag getEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.startTag.getName();
    }

    public boolean isEmpty() {
        return this.startTag.end == this.getContentEnd();
    }

    public boolean isEmptyElementTag() {
        return this.startTag.isEmptyElementTag();
    }

    public static boolean isBlock(String name) {
        return Tag.isBlock(name);
    }

    public static boolean isInline(String name) {
        return Tag.isInline(name);
    }

    public Attributes getAttributes() {
        return this.getStartTag().getAttributes();
    }

    public String toString() {
        return "Element " + super.toString() + ": " + this.startTag + "-" + this.endTag;
    }

    private int getContentEnd() {
        return this.endTag != null ? this.endTag.begin : this.end;
    }
}

