/*
 * Decompiled with CFR 0.152.
 */
package jargs.examples.gnu;

import jargs.gnu.CmdLineParser;

public class OptionTest {
    private static void printUsage() {
        System.err.println("usage: prog [{-v,--verbose}] [{-n,--name} a_name][{-s,--size} a_number] [{-f,--fraction} a_float]");
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option verbose = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option size = parser.addIntegerOption('s', "size");
        CmdLineParser.Option name = parser.addStringOption('n', "name");
        CmdLineParser.Option fraction = parser.addDoubleOption('f', "fraction");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            OptionTest.printUsage();
            System.exit(2);
        }
        Boolean verboseValue = (Boolean)parser.getOptionValue(verbose);
        Integer sizeValue = (Integer)parser.getOptionValue(size);
        String nameValue = (String)parser.getOptionValue(name);
        Double fractionValue = (Double)parser.getOptionValue(fraction);
        System.out.println("verbose: " + verboseValue);
        System.out.println("size: " + sizeValue);
        System.out.println("name: " + nameValue);
        System.out.println("fraction: " + fractionValue);
        String[] otherArgs = parser.getRemainingArgs();
        System.out.println("remaining args: ");
        int i = 0;
        while (i < otherArgs.length) {
            System.out.println(otherArgs[i]);
            ++i;
        }
        System.exit(0);
    }
}

