/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterEntityReference;
import au.id.jericho.lib.html.NumericCharacterReference;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int INVALID_CODE_POINT = -1;

    CharacterReference(Source source, int n, int n2, int n3) {
        super(source, n, n2);
        this.codePoint = n3;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = CharacterEntityReference.getName(c);
            if (string2 != null) {
                if (c == '\'') {
                    stringBuffer.append("&#39;");
                    continue;
                }
                CharacterEntityReference.appendCharacterReferenceString(stringBuffer, string2);
                continue;
            }
            if (c > '\u007f') {
                CharacterReference.appendDecimalCharacterReferenceString(stringBuffer, c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) {
        CharacterReference characterReference;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        int n2 = 0;
        Source source = new Source(string);
        StringBuffer stringBuffer = new StringBuffer();
        while ((characterReference = CharacterReference.findPreviousOrNext(source, n, false)) != null) {
            if (n2 != characterReference.getBegin()) {
                stringBuffer.append(string.substring(n2, characterReference.getBegin()));
            }
            stringBuffer.append((char)characterReference.codePoint);
            n = n2 = characterReference.getEnd();
        }
        if (n2 != string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    static CharacterReference findPreviousOrNext(Source source, int n, boolean bl) {
        String string = source.getParseTextLowerCase();
        int n2 = n = bl ? string.lastIndexOf(38, n) : string.indexOf(38, n);
        while (n != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, n);
            if (characterReference != null) {
                return characterReference;
            }
            n = bl ? string.lastIndexOf(38, n - 1) : string.indexOf(38, n + 1);
        }
        return null;
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int n) {
        String string = CharacterEntityReference.getCharacterReferenceString(n);
        if (string == null) {
            string = NumericCharacterReference.getCharacterReferenceString(n);
        }
        return string;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int n) {
        return CharacterReference.appendDecimalCharacterReferenceString(new StringBuffer(), n).toString();
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int n) {
        return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuffer(), n).toString();
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int n) {
        return CharacterReference.appendUnicodeText(new StringBuffer(), n).toString();
    }

    static final StringBuffer appendUnicodeText(StringBuffer stringBuffer, int n) {
        stringBuffer.append("U+");
        String string = Integer.toString(n, 16).toUpperCase();
        for (int i = 4 - string.length(); i > 0; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    public static CharacterReference parse(String string) {
        return CharacterReference.construct(new Source(string), 0);
    }

    public static int getCodePointFromCharacterReferenceString(String string) {
        CharacterReference characterReference = CharacterReference.parse(string);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    public static final boolean requiresEncoding(char c) {
        return c > '\u007f' || CharacterEntityReference.getName(c) != null;
    }

    static final StringBuffer appendHexadecimalCharacterReferenceString(StringBuffer stringBuffer, int n) {
        return stringBuffer.append("&#x").append(Integer.toString(n, 16)).append(';');
    }

    static final StringBuffer appendDecimalCharacterReferenceString(StringBuffer stringBuffer, int n) {
        return stringBuffer.append("&#").append(n).append(';');
    }

    static CharacterReference construct(Source source, int n) {
        try {
            if (source.getParseTextLowerCase().charAt(n) != '&') {
                return null;
            }
            return source.getParseTextLowerCase().charAt(n + 1) == '#' ? NumericCharacterReference.construct(source, n) : CharacterEntityReference.construct(source, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }
}

