/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationParser {
    private static final boolean DEBUG = true;
    private static final String INLCUDE_TAG_NAME = "include";
    private static final String SHAPE_TAG_NAME = "shape";
    private static final String SHAPE_GROUP_TAG_NAME = "shapes";
    private String currentDir = "";
    private File configFile;
    private HashMap<String, CustomShapeDefinition> shapeDefinitions = new HashMap();

    public Collection<CustomShapeDefinition> getShapeDefinitions() {
        return this.shapeDefinitions.values();
    }

    public HashMap<String, CustomShapeDefinition> getShapeDefinitionsHash() {
        return this.shapeDefinitions;
    }

    public void parseFile(File file) throws ParserConfigurationException, SAXException, IOException {
        this.configFile = file;
        XMLHandler handler = new XMLHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(file, (DefaultHandler)handler);
    }

    private String createFilename(String baseDir, String filename) {
        if (baseDir == null || baseDir.trim().equals("")) {
            return filename;
        }
        if (baseDir.endsWith(File.separator)) {
            return String.valueOf(baseDir) + filename;
        }
        return String.valueOf(baseDir) + File.separator + filename;
    }

    private boolean getBooleanFromAttributeValue(String value) {
        if ("no".equals(value = value.toLowerCase())) {
            return false;
        }
        if ("false".equals(value)) {
            return false;
        }
        if ("yes".equals(value)) {
            return true;
        }
        if ("true".equals(value)) {
            return true;
        }
        throw new IllegalArgumentException("value " + value + " cannot be interpreted as a boolean");
    }

    public static void main(String[] argv) throws ParserConfigurationException, SAXException, IOException {
        ConfigurationParser parser = new ConfigurationParser();
        parser.parseFile(new File("config.xml"));
        parser.getShapeDefinitions();
    }

    private class XMLHandler
    extends DefaultHandler {
        private XMLHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(ConfigurationParser.SHAPE_GROUP_TAG_NAME)) {
                if (attributes.getLength() == 1) {
                    ConfigurationParser.this.currentDir = attributes.getValue(0).trim();
                    if (ConfigurationParser.this.currentDir.equals("")) {
                        ConfigurationParser.this.currentDir = ConfigurationParser.this.configFile.getParentFile().getAbsolutePath();
                    }
                } else {
                    ConfigurationParser.this.currentDir = ConfigurationParser.this.configFile.getParentFile().getAbsolutePath();
                }
            }
            if (qName.equals(ConfigurationParser.SHAPE_TAG_NAME)) {
                File file;
                CustomShapeDefinition definition = new CustomShapeDefinition();
                int len = attributes.getLength();
                int i = 0;
                while (i < len) {
                    String name = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    if (name.equals("tag")) {
                        definition.setTag(value);
                    } else if (name.equals("stretch")) {
                        definition.setStretches(ConfigurationParser.this.getBooleanFromAttributeValue(value));
                    } else if (name.equals("border")) {
                        definition.setHasBorder(ConfigurationParser.this.getBooleanFromAttributeValue(value));
                    } else if (name.equals("shadow")) {
                        definition.setDropsShadow(ConfigurationParser.this.getBooleanFromAttributeValue(value));
                    } else if (name.equals("comment")) {
                        definition.setComment(value);
                    } else if (name.equals("filename")) {
                        File file2 = new File(value);
                        if (file2.isAbsolute()) {
                            definition.setFilename(value);
                        } else {
                            definition.setFilename(ConfigurationParser.this.createFilename(ConfigurationParser.this.currentDir, value));
                        }
                    }
                    ++i;
                }
                if (ConfigurationParser.this.shapeDefinitions.containsKey(definition.getTag())) {
                    CustomShapeDefinition oldDef = (CustomShapeDefinition)ConfigurationParser.this.shapeDefinitions.get(definition.getTag());
                    System.err.println("*** Warning: shape \"" + oldDef.getTag() + "\" (file: " + oldDef.getFilename() + ") has been redefined as file: " + definition.getFilename());
                }
                if ((file = new File(definition.getFilename())).exists()) {
                    ConfigurationParser.this.shapeDefinitions.put(definition.getTag(), definition);
                    System.out.println(definition);
                } else {
                    System.err.println("File " + file + " does not exist, skipping tag " + definition.getTag());
                }
            }
            if (qName.equals(ConfigurationParser.INLCUDE_TAG_NAME) && attributes.getLength() == 1) {
                File includedFile = new File(attributes.getValue(0).trim());
                if (!includedFile.isAbsolute()) {
                    includedFile = new File(ConfigurationParser.this.createFilename(ConfigurationParser.this.configFile.getParentFile().getAbsolutePath(), includedFile.getPath()));
                }
                if (!includedFile.exists()) {
                    System.err.println("Included file " + includedFile + " does not exist, skipping");
                    return;
                }
                ConfigurationParser configParser = new ConfigurationParser();
                try {
                    configParser.parseFile(includedFile);
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                HashMap<String, CustomShapeDefinition> shapes = configParser.getShapeDefinitionsHash();
                ConfigurationParser.this.shapeDefinitions.putAll(shapes);
            }
        }
    }
}

