/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import java.util.HashMap;
import java.util.HashSet;

public final class FormControlType {
    private String formControlTypeId;
    private String tagName;
    private boolean allowsMultipleValues;
    private boolean predefinedValue;
    private static HashMap map = new HashMap();
    private static HashSet tagNames = new HashSet();
    public static final FormControlType TEXT = FormControlType.construct(new FormControlType("text", "input", true, false));
    public static final FormControlType PASSWORD = FormControlType.construct(new FormControlType("password", "input", true, false));
    public static final FormControlType HIDDEN = FormControlType.construct(new FormControlType("hidden", "input", true, false));
    public static final FormControlType TEXTAREA = FormControlType.construct(new FormControlType("textarea", "textarea", true, false));
    public static final FormControlType CHECKBOX = FormControlType.construct(new FormControlType("checkbox", "input", true, true));
    public static final FormControlType RADIO = FormControlType.construct(new FormControlType("radio", "input", false, true));
    public static final FormControlType FILE = FormControlType.construct(new FormControlType("file", "input", true, false));
    public static final FormControlType BUTTON = FormControlType.construct(new FormControlType("button", "button", false, true));
    public static final FormControlType SUBMIT = FormControlType.construct(new FormControlType("submit", "input", false, true));
    public static final FormControlType IMAGE = FormControlType.construct(new FormControlType("image", "input", false, true));
    public static final FormControlType SELECT_SINGLE = FormControlType.construct(new FormControlType("select_single", "select", false, true));
    public static final FormControlType SELECT_MULTIPLE = FormControlType.construct(new FormControlType("select_multiple", "select", true, true));

    private static FormControlType construct(FormControlType formControlType) {
        map.put(formControlType.formControlTypeId, formControlType);
        tagNames.add(formControlType.tagName);
        return formControlType;
    }

    private FormControlType(String formControlTypeId, String tagName, boolean allowsMultipleValues, boolean predefinedValue) {
        this.formControlTypeId = formControlTypeId;
        this.tagName = tagName;
        this.allowsMultipleValues = allowsMultipleValues;
        this.predefinedValue = predefinedValue;
    }

    public String getFormControlTypeId() {
        return this.formControlTypeId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean allowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public boolean isPredefinedValue() {
        return this.predefinedValue;
    }

    public boolean isSubmit() {
        return this == SUBMIT || this == BUTTON || this == IMAGE;
    }

    public String[] getAdditionalSubmitNames(String name) {
        if (this != IMAGE) {
            return null;
        }
        String[] names = new String[]{String.valueOf(name) + ".x", String.valueOf(name) + ".y"};
        return names;
    }

    public static FormControlType get(String formControlTypeId) {
        return (FormControlType)map.get(formControlTypeId);
    }

    public static boolean isPotentialControl(String tagName) {
        return tagNames.contains(tagName);
    }

    public String toString() {
        return "formControlTypeId=" + this.formControlTypeId + ", tagName=" + this.tagName + ", allowsMultipleValues=" + this.allowsMultipleValues + ", predefinedValue=" + this.predefinedValue;
    }
}

