/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class IntStringHashMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry[] table;
    private transient int size;
    private int threshold;
    private float loadFactor;

    public IntStringHashMap(int n, float f) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
    }

    public IntStringHashMap(int n) {
        this(n, 0.75f);
    }

    public IntStringHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    private static int getHash(int n) {
        return n;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String get(int n) {
        int n2 = IntStringHashMap.getHash(n);
        int n3 = IntStringHashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (n == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsKey(int n) {
        return this.get(n) != null;
    }

    private Entry getEntry(int n) {
        int n2 = IntStringHashMap.getHash(n);
        int n3 = IntStringHashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null && n != entry.key) {
            entry = entry.next;
        }
        return entry;
    }

    public String put(int n, String string) {
        int n2 = IntStringHashMap.getHash(n);
        int n3 = IntStringHashMap.indexFor(n2, this.table.length);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (n == entry.key) {
                String string2 = entry.value;
                entry.value = string;
                return string2;
            }
            entry = entry.next;
        }
        this.table[n3] = new Entry(n, string, this.table[n3]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return null;
    }

    private void resize(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    private void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry = entryArray2[i];
            while (entry != null) {
                Entry entry2 = entry.next;
                int n2 = IntStringHashMap.indexFor(entry.key, n);
                entry.next = entryArray[n2];
                entryArray[n2] = entry;
                entry = entry2;
            }
        }
    }

    public String remove(int n) {
        Entry entry;
        int n2 = IntStringHashMap.getHash(n);
        int n3 = IntStringHashMap.indexFor(n2, this.table.length);
        Entry entry2 = entry = this.table[n3];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n == entry2.key) {
                --this.size;
                if (entry == entry2) {
                    this.table[n3] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(String string) {
        if (string == null) {
            return this.containsNullValue();
        }
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                if (string.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return new Integer(this.nextEntry().key);
        }

        public int nextKey() {
            return this.nextEntry().key;
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next = null;
        int index;
        Entry current;

        HashIterator() {
            this.index = IntStringHashMap.this.table.length;
            if (IntStringHashMap.this.size != 0) {
                while (this.index > 0 && (this.next = IntStringHashMap.this.table[--this.index]) == null) {
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Entry nextEntry() {
            this.current = this.next;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.next = this.current.next;
            while (this.next == null && this.index > 0) {
                this.next = IntStringHashMap.this.table[--this.index];
            }
            return this.current;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Entry {
        final int key;
        String value;
        Entry next;

        Entry(int n, String string, Entry entry) {
            this.key = n;
            this.value = string;
            this.next = entry;
        }

        public int getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String setValue(String string) {
            String string2 = this.value;
            this.value = string;
            return string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.key == entry.key && (this.value == entry.value || this.value != null && this.value.equals(entry.value));
        }

        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

