/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Attributes
extends Segment {
    private ArrayList attributeList = null;
    private static final int AFTER_TAG_NAME = 0;
    private static final int BETWEEN_ATTRIBUTES = 1;
    private static final int IN_NAME = 2;
    private static final int AFTER_NAME = 3;
    private static final int START_VALUE = 4;
    private static final int IN_VALUE = 5;
    private static final int AFTER_VALUE_FINAL_QUOTE = 6;
    private static int defaultMaxErrorCount = 1;

    private Attributes(Source source, int begin, int end, ArrayList attributeList) {
        super(source, begin, end);
        this.attributeList = attributeList;
    }

    static Attributes construct(Source source, int begin, int maxEnd, int maxErrorCount) {
        return Attributes.construct(source, "Attributes", 1, begin, -1, maxEnd, null, maxErrorCount);
    }

    static Attributes construct(Source source, int startTagBegin, int attributesBegin, int maxEnd, String startTagName, int maxErrorCount) {
        return Attributes.construct(source, "Attributes for StartTag", 1, startTagBegin, attributesBegin, maxEnd, startTagName, maxErrorCount);
    }

    static Attributes construct(Source source, int startTagBegin, String startTagName) {
        return Attributes.construct(source, "StartTag", 0, startTagBegin, -1, -1, startTagName, defaultMaxErrorCount);
    }

    /*
     * Unable to fully structure code
     */
    private static Attributes construct(Source source, String logType, int state, int logBegin, int attributesBegin, int maxEnd, String startTagName, int maxErrorCount) {
        optionalTerminatingChar = 47;
        if (startTagName != null) {
            if (attributesBegin == -1) {
                attributesBegin = logBegin + 1 + startTagName.length();
            }
            if (startTagName.charAt(0) == '?') {
                optionalTerminatingChar = 63;
            }
        } else {
            attributesBegin = logBegin;
        }
        attributeList = new ArrayList<Attribute>();
        lsource = source.getParseTextLowerCase();
        i = attributesBegin;
        quote = 32;
        nameSegment = null;
        key = null;
        currentBegin = -1;
        isTerminatingCharacter = false;
        errorCount = 0;
        try {
            while (!isTerminatingCharacter) {
                c = lsource.charAt(i);
                if (c == 62 || i == maxEnd || c == optionalTerminatingChar && lsource.charAt(i + 1) == '>') {
                    isTerminatingCharacter = true;
                }
                switch (state) {
                    case 5: {
                        if (!isTerminatingCharacter && c != quote && (quote != 32 || !Segment.isWhiteSpace((char)c))) ** GOTO lbl45
                        if (quote != 32) ** GOTO lbl29
                        valueSegment = valueSegmentIncludingQuotes = new Segment(source, currentBegin, i);
                        ** GOTO lbl41
lbl29:
                        // 1 sources

                        if (!isTerminatingCharacter) ** GOTO lbl39
                        if (i == maxEnd) {
                            source.log(logType, startTagName, logBegin, "terminated in the middle of a quoted attribute value", i);
                            if (Attributes.reachedMaxErrorCount(++errorCount, source, logType, startTagName, logBegin, maxErrorCount)) {
                                return null;
                            }
                            valueSegment = new Segment(source, currentBegin, i);
                            valueSegmentIncludingQuotes = new Segment(source, currentBegin - 1, i);
                        } else {
                            isTerminatingCharacter = false;
                            break;
lbl39:
                            // 1 sources

                            valueSegment = new Segment(source, currentBegin, i);
                            valueSegmentIncludingQuotes = new Segment(source, currentBegin - 1, i + 1);
                        }
lbl41:
                        // 3 sources

                        attributeList.add(new Attribute(source, key, nameSegment, valueSegment, valueSegmentIncludingQuotes));
                        state = 1;
                        break;
lbl45:
                        // 1 sources

                        if (c != 60 || quote != 32) break;
                        source.log(logType, startTagName, logBegin, "rejected because of '<' character in unquoted attribute value", i);
                        return null;
                    }
                    case 2: {
                        if (isTerminatingCharacter || c == 61 || Segment.isWhiteSpace((char)c)) {
                            nameSegment = new Segment(source, currentBegin, i);
                            key = nameSegment.getSourceText().toLowerCase();
                            if (isTerminatingCharacter) {
                                attributeList.add(new Attribute(source, key, nameSegment));
                                break;
                            }
                            state = c == 61 ? 4 : 3;
                            break;
                        }
                        if (Segment.isIdentifierPart((char)c)) break;
                        if (c == 60) {
                            source.log(logType, startTagName, logBegin, "rejected because of '<' character in attribute name", i);
                            return null;
                        }
                        source.log(logType, startTagName, logBegin, "contains attribute name with invalid character", i);
                        if (!Attributes.reachedMaxErrorCount(++errorCount, source, logType, startTagName, logBegin, maxErrorCount)) break;
                        return null;
                    }
                    case 3: {
                        if (isTerminatingCharacter || c != 61 && !Segment.isWhiteSpace((char)c)) {
                            attributeList.add(new Attribute(source, key, nameSegment));
                            if (isTerminatingCharacter) break;
                            state = 1;
                            --i;
                            break;
                        }
                        if (c != 61) break;
                        state = 4;
                        break;
                    }
                    case 1: {
                        if (isTerminatingCharacter) break;
                        if (Segment.isWhiteSpace((char)c)) {
                            quote = 32;
                            break;
                        }
                        if (quote != 32) {
                            source.log(logType, startTagName, logBegin, "has missing whitespace after quoted attribute value", i);
                        }
                        if (!Segment.isIdentifierStart((char)c)) {
                            if (c == 60) {
                                source.log(logType, startTagName, logBegin, "rejected because of '<' character", i);
                                return null;
                            }
                            source.log(logType, startTagName, logBegin, "contains attribute name with invalid first character", i);
                            if (Attributes.reachedMaxErrorCount(++errorCount, source, logType, startTagName, logBegin, maxErrorCount)) {
                                return null;
                            }
                        }
                        state = 2;
                        currentBegin = i;
                        break;
                    }
                    case 4: {
                        currentBegin = i;
                        if (isTerminatingCharacter) {
                            source.log(logType, startTagName, logBegin, "has missing attribute value after '=' sign", i);
                            valueSegment = new Segment(source, i, i);
                            attributeList.add(new Attribute(source, key, nameSegment, valueSegment, valueSegment));
                            state = 1;
                            break;
                        }
                        if (Segment.isWhiteSpace((char)c)) break;
                        if (c == 60) {
                            source.log(logType, startTagName, logBegin, "rejected because of '<' character at start of attribuite value", i);
                            return null;
                        }
                        if (c == 39 || c == 34) {
                            quote = c;
                            ++currentBegin;
                        } else {
                            quote = 32;
                        }
                        state = 5;
                        break;
                    }
                    case 0: {
                        if (isTerminatingCharacter) break;
                        if (!Segment.isWhiteSpace((char)c)) {
                            source.log(logType, startTagName, logBegin, "rejected because name contains invalid character", i);
                            return null;
                        }
                        state = 1;
                    }
                }
                ++i;
            }
            return new Attributes(source, attributesBegin, i - 1, attributeList);
        }
        catch (IndexOutOfBoundsException ex) {
            source.log(logType, startTagName, logBegin, "rejected because it has no closing '>' character", -1);
            return null;
        }
    }

    private static boolean reachedMaxErrorCount(int errorCount, Source source, String logType, String startTagName, int logBegin, int maxErrorCount) {
        if (errorCount <= maxErrorCount) {
            return false;
        }
        source.log(logType, startTagName, logBegin, "rejected because it contains too many errors", -1);
        return true;
    }

    public Attribute get(String name) {
        if (this.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.size()) {
            Attribute attribute = (Attribute)this.attributeList.get(i);
            if (attribute.getKey().equalsIgnoreCase(name)) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    public List getList() {
        return this.attributeList;
    }

    public int getCount() {
        return this.attributeList.size();
    }

    public int size() {
        return this.getCount();
    }

    public Iterator iterator() {
        return ((AbstractList)this.attributeList).iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Attributes ").append(super.toString()).append(": ");
        if (this.attributeList == null) {
            sb.append("EMPTY");
        } else {
            sb.append('\n');
            Iterator i = ((AbstractList)this.attributeList).iterator();
            while (i.hasNext()) {
                Attribute attribute = (Attribute)i.next();
                sb.append("  ").append(attribute.toString());
            }
        }
        return sb.toString();
    }

    public static int getDefaultMaxErrorCount() {
        return defaultMaxErrorCount;
    }

    public static void setDefaultMaxErrorCount(int value) {
        defaultMaxErrorCount = value;
    }
}

