/*
 * Decompiled with CFR 0.152.
 */
package jargs.examples.gnu;

import jargs.gnu.CmdLineParser;

public class OptionParserSubclassTest {
    private static void printUsage() {
        System.err.println("usage: prog [{-v,--verbose}] [{-n,--name} a_name][{-s,--size} a_number] [{-f,--fraction} a_float]");
    }

    public static void main(String[] args) {
        MyOptionsParser myOptions = new MyOptionsParser();
        try {
            myOptions.parse(args);
        }
        catch (CmdLineParser.UnknownOptionException e) {
            System.err.println(e.getMessage());
            OptionParserSubclassTest.printUsage();
            System.exit(2);
        }
        catch (CmdLineParser.IllegalOptionValueException e) {
            System.err.println(e.getMessage());
            OptionParserSubclassTest.printUsage();
            System.exit(2);
        }
        CmdLineParser.Option[] allOptions = new CmdLineParser.Option[]{MyOptionsParser.VERBOSE, MyOptionsParser.NAME, MyOptionsParser.SIZE, MyOptionsParser.FRACTION};
        int j = 0;
        while (j < allOptions.length) {
            System.out.println(String.valueOf(allOptions[j].longForm()) + ": " + myOptions.getOptionValue(allOptions[j]));
            ++j;
        }
        String[] otherArgs = myOptions.getRemainingArgs();
        System.out.println("remaining args: ");
        int i = 0;
        while (i < otherArgs.length) {
            System.out.println(otherArgs[i]);
            ++i;
        }
        System.exit(0);
    }

    private static class MyOptionsParser
    extends CmdLineParser {
        public static final CmdLineParser.Option VERBOSE = new CmdLineParser.Option.BooleanOption('v', "verbose");
        public static final CmdLineParser.Option SIZE = new CmdLineParser.Option.IntegerOption('s', "size");
        public static final CmdLineParser.Option NAME = new CmdLineParser.Option.StringOption('n', "name");
        public static final CmdLineParser.Option FRACTION = new CmdLineParser.Option.DoubleOption('f', "fraction");

        public MyOptionsParser() {
            this.addOption(VERBOSE);
            this.addOption(SIZE);
            this.addOption(NAME);
            this.addOption(FRACTION);
        }
    }
}

