/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import org.stathissideris.ascii2image.core.FileUtils;
import org.stathissideris.ascii2image.graphics.OffScreenSVGRenderer;

public class ImageHandler {
    private static OffScreenSVGRenderer svgRenderer = new OffScreenSVGRenderer();
    private static ImageHandler instance = new ImageHandler();
    private static final MediaTracker tracker = new MediaTracker(new JLabel());

    public static ImageHandler instance() {
        return instance;
    }

    public Image loadImage(String filename) {
        URL url = ClassLoader.getSystemResource(filename);
        Image result = null;
        result = url != null ? Toolkit.getDefaultToolkit().getImage(url) : Toolkit.getDefaultToolkit().getImage(filename);
        tracker.addImage(result, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            System.err.println("Failed to load image " + filename);
            e.printStackTrace();
        }
        tracker.removeImage(result, 0);
        return result;
    }

    public BufferedImage renderSVG(String filename, int width, int height, boolean stretch) throws IOException {
        File file = new File(filename);
        URI uri = file.toURI();
        return svgRenderer.renderToImage(uri.toString(), width, height, stretch, null, null);
    }

    public BufferedImage renderSVG(String filename, int width, int height, boolean stretch, String idRegex, Color color) throws IOException {
        File file = new File(filename);
        URI uri = file.toURI();
        return svgRenderer.renderToImage(uri.toString(), width, height, stretch, idRegex, color);
    }

    public static void main(String[] args) throws IOException {
        OffScreenSVGRenderer renderer = new OffScreenSVGRenderer();
        String content = FileUtils.readFile(new File("sphere.svg")).replaceAll("#187637", "#1133FF");
        System.out.println(content);
        BufferedImage image = renderer.renderXMLToImage(content, 200, 200, false, null, null);
        try {
            File file = new File("testing.png");
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            System.err.println("Error: Cannot write to file");
        }
    }
}

