/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import java.util.HashMap;

final class SearchCache {
    private static final String START_TAG_PREFIX = "ST";
    private static final String END_TAG_PREFIX = "ET";
    private static final String ELEMENT_PREFIX = "E";
    private static final String TAG_PREFIX = "T";
    private final HashMap cache = new HashMap();

    SearchCache() {
    }

    static String getStartTagKey(int searchStartPos, String name, boolean previous) {
        if (name == Tag.SERVER_MASON_NAMED_BLOCK) {
            name = "%named>";
        }
        return SearchCache.getKey(START_TAG_PREFIX, searchStartPos, name, previous);
    }

    StartTag getStartTag(String key) {
        return (StartTag)this.cache.get(key);
    }

    void setStartTag(String key, StartTag startTag) {
        this.cache.put(key, startTag == null ? StartTag.CACHED_NULL : startTag);
    }

    static String getEndTagKey(int searchStartPos, String name, boolean previous) {
        return SearchCache.getKey(END_TAG_PREFIX, searchStartPos, name, previous);
    }

    static String getEndTagKey(int forwardSearchStartPos) {
        return ELEMENT_PREFIX + forwardSearchStartPos;
    }

    EndTag getEndTag(String key) {
        return (EndTag)this.cache.get(key);
    }

    void setEndTag(String key, EndTag endTag) {
        this.cache.put(key, endTag == null ? EndTag.CACHED_NULL : endTag);
    }

    static String getElementKey(StartTag startTag) {
        return END_TAG_PREFIX + startTag.begin;
    }

    Element getElement(String key) {
        return (Element)this.cache.get(key);
    }

    void setElement(String key, Element element) {
        this.cache.put(key, element);
    }

    static String getTagKey(int atPos) {
        return TAG_PREFIX + atPos;
    }

    Tag getTag(String key) {
        return (Tag)this.cache.get(key);
    }

    void setTag(String key, Tag tag) {
        this.cache.put(key, tag == null ? Tag.CACHED_NULL : tag);
    }

    private static String getKey(String prefix, int pos, String name, boolean previous) {
        StringBuffer sb = new StringBuffer(prefix);
        sb.append(pos);
        if (name != null) {
            sb.append(name);
        }
        if (previous) {
            sb.append('<');
        }
        return sb.toString();
    }
}

