/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.SearchCache;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Tag;

public final class EndTag
extends Tag {
    static final EndTag CACHED_NULL = new EndTag();

    private EndTag() {
    }

    EndTag(Source source, int begin, int end, String name) {
        super(source, begin, end, name);
    }

    public static boolean isForbidden(String name) {
        return Tag.isEndTagForbidden(name);
    }

    public static boolean isOptional(String name) {
        return Tag.isEndTagOptional(name);
    }

    public static boolean isRequired(String name) {
        return Tag.isEndTagRequired(name);
    }

    static EndTag findPreviousOrNext(Source source, int pos, String name, boolean previous) {
        String cacheKey = SearchCache.getEndTagKey(pos, name, previous);
        EndTag endTag = source.getSearchCache().getEndTag(cacheKey);
        if (endTag == null) {
            endTag = EndTag.findPreviousOrNextUncached(source, pos, name, previous);
            source.getSearchCache().setEndTag(cacheKey, endTag);
        }
        return endTag == CACHED_NULL ? null : endTag;
    }

    private static EndTag findPreviousOrNextUncached(Source source, int pos, String name, boolean previous) {
        Segment enclosingComment = source.findEnclosingComment(pos);
        if (enclosingComment != null) {
            pos = previous ? enclosingComment.begin : enclosingComment.end;
        }
        try {
            int begin;
            String searchString = "</" + name + ">";
            String lsource = source.getParseTextLowerCase();
            int n = begin = previous ? lsource.lastIndexOf(searchString, pos) : lsource.indexOf(searchString, pos);
            if (begin == -1) {
                return null;
            }
            return new EndTag(source, begin, begin + searchString.length(), name);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    static EndTag findNext(Source source, int pos) {
        String cacheKey = SearchCache.getEndTagKey(pos);
        EndTag endTag = source.getSearchCache().getEndTag(cacheKey);
        if (endTag == null) {
            endTag = EndTag.findNextUncached(source, pos);
            source.getSearchCache().setEndTag(cacheKey, endTag);
        }
        return endTag == CACHED_NULL ? null : endTag;
    }

    private static EndTag findNextUncached(Source source, int pos) {
        try {
            Segment enclosingComment = source.findEnclosingComment(pos);
            if (enclosingComment != null) {
                return EndTag.findNext(source, enclosingComment.end);
            }
            String lsource = source.getParseTextLowerCase();
            int begin = lsource.indexOf("</", pos);
            if (begin == -1) {
                return null;
            }
            int nameBegin = begin + 2;
            int nameEnd = source.getIdentifierEnd(nameBegin, true);
            if (nameEnd == -1) {
                return EndTag.findNext(source, nameBegin);
            }
            if (lsource.charAt(nameEnd) != '>') {
                return EndTag.findNext(source, nameEnd);
            }
            String name = lsource.substring(nameBegin, nameEnd);
            return new EndTag(source, begin, nameEnd + 1, name);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }
}

