/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import jargs.gnu.CmdLineParser;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.core.RenderingOptions;

public class ConversionOptions {
    public ProcessingOptions processingOptions = new ProcessingOptions();
    public RenderingOptions renderingOptions = new RenderingOptions();

    public void setDebug(boolean value) {
        this.processingOptions.setPrintDebugOutput(value);
        this.renderingOptions.setRenderDebugLines(value);
    }

    public ConversionOptions() {
    }

    public ConversionOptions(CmdLineParser parser) {
        Integer tabSize;
        String markupMode;
        String tagsMode;
        String colorCodeMode;
        String exportFormat;
        Boolean noAntialias;
        Boolean noSeparation;
        Boolean roundCorners;
        Double scale;
        Boolean overwrite;
        Boolean debug;
        Boolean shadows;
        Boolean verbosity = (Boolean)parser.getOptionValue("verbose");
        if (verbosity != null) {
            this.processingOptions.setVerbose(verbosity);
        }
        if ((shadows = (Boolean)parser.getOptionValue("no-shadows")) != null) {
            this.renderingOptions.setDropShadows(shadows == false);
        }
        if ((debug = (Boolean)parser.getOptionValue("debug")) != null) {
            this.setDebug(debug);
        }
        if ((overwrite = (Boolean)parser.getOptionValue("overwrite")) != null) {
            this.processingOptions.setOverwriteFiles(overwrite);
        }
        if ((scale = (Double)parser.getOptionValue("scale")) != null) {
            this.renderingOptions.setScale(scale.floatValue());
        }
        if ((roundCorners = (Boolean)parser.getOptionValue("round-corners")) != null) {
            this.processingOptions.setAllCornersAreRound(roundCorners);
        }
        if ((noSeparation = (Boolean)parser.getOptionValue("no-separation")) != null) {
            this.processingOptions.setPerformSeparationOfCommonEdges(noSeparation == false);
        }
        if ((noAntialias = (Boolean)parser.getOptionValue("no-antialias")) != null) {
            this.renderingOptions.setAntialias(noAntialias == false);
        }
        if ((exportFormat = (String)parser.getOptionValue("format")) != null) {
            if ((exportFormat = exportFormat.toLowerCase()) == "jpeg" || exportFormat == "jpg") {
                this.processingOptions.setExportFormat(0);
            } else if (exportFormat == "png") {
                this.processingOptions.setExportFormat(1);
            } else if (exportFormat == "gif") {
                this.processingOptions.setExportFormat(2);
            }
        }
        if ((colorCodeMode = (String)parser.getOptionValue("color-codes")) != null) {
            if (colorCodeMode.equals("use")) {
                this.processingOptions.setColorCodesProcessingMode(0);
            } else if (colorCodeMode.equals("ignore")) {
                this.processingOptions.setColorCodesProcessingMode(2);
            } else if (colorCodeMode.equals("render")) {
                this.processingOptions.setColorCodesProcessingMode(1);
            }
        }
        if ((tagsMode = (String)parser.getOptionValue("tags")) != null) {
            if (tagsMode.equals("use")) {
                this.processingOptions.setTagProcessingMode(0);
            } else if (tagsMode.equals("ignore")) {
                this.processingOptions.setTagProcessingMode(2);
            } else if (tagsMode.equals("render")) {
                this.processingOptions.setTagProcessingMode(1);
            }
        }
        if ((markupMode = (String)parser.getOptionValue("markup")) != null) {
            if (markupMode.equals("use")) {
                this.processingOptions.setColorCodesProcessingMode(0);
                this.processingOptions.setTagProcessingMode(0);
            } else if (markupMode.equals("ignore")) {
                this.processingOptions.setColorCodesProcessingMode(2);
                this.processingOptions.setTagProcessingMode(2);
            } else if (markupMode.equals("render")) {
                this.processingOptions.setColorCodesProcessingMode(1);
                this.processingOptions.setTagProcessingMode(1);
            }
        }
        if ((tabSize = (Integer)parser.getOptionValue("tabs")) != null) {
            int tabSizeValue = tabSize;
            if (tabSizeValue < 0) {
                tabSizeValue = 0;
            }
            this.processingOptions.setTabSize(tabSizeValue);
        }
    }
}

