/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.stathissideris.ascii2image.text.AbstractionGrid;
import org.stathissideris.ascii2image.text.TextGrid;

public class CellSet
extends ArrayList {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE_DEBUG = false;
    public static final int TYPE_CLOSED = 0;
    public static final int TYPE_OPEN = 1;
    public static final int TYPE_MIXED = 2;
    public static final int TYPE_HAS_CLOSED_AREA = 3;
    public static final int TYPE_UNDETERMINED = 4;
    private int type = 4;
    private boolean typeIsValid = false;

    public static void main(String[] args) {
        TextGrid g = new TextGrid();
        CellSet set = new CellSet();
        set.add(new TextGrid.Cell(g, 10, 20));
        set.add(new TextGrid.Cell(g, 10, 60));
        set.add(new TextGrid.Cell(g, 10, 30));
        set.add(new TextGrid.Cell(g, 60, 20));
        set.printDebug();
        set.remove(set.find(new TextGrid.Cell(g, 10, 30)));
        set.printDebug();
    }

    public void printAsGrid() {
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        grid.printDebug();
    }

    public void printDebug() {
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            System.out.print(cell);
            if (!it.hasNext()) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    public CellSet(int arg0) {
        super(arg0);
    }

    public CellSet() {
    }

    public CellSet(Collection arg0) {
        super(arg0);
    }

    public static CellSet copyCellSet(CellSet set) {
        TextGrid grid = new TextGrid();
        CellSet newSet = new CellSet();
        Iterator it = ((AbstractList)set).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            TextGrid.Cell newCell = new TextGrid.Cell(grid, cell);
            newSet.add(newCell);
        }
        return newSet;
    }

    public int getType(TextGrid grid) {
        if (this.typeIsValid) {
            return this.type;
        }
        this.typeIsValid = true;
        if (this.size() == 1) {
            this.type = 1;
            return 1;
        }
        int typeTrace = this.getTypeAccordingToTraceMethod(grid);
        if (typeTrace == 1) {
            this.type = 1;
            return 1;
        }
        if (typeTrace == 0) {
            this.type = 0;
            return 0;
        }
        if (typeTrace == 4) {
            int typeFill = this.getTypeAccordingToFillMethod(grid);
            if (typeFill == 3) {
                this.type = 2;
                return 2;
            }
            if (typeFill == 1) {
                this.type = 1;
                return 1;
            }
        }
        this.type = 4;
        return 4;
    }

    private int getTypeAccordingToTraceMethod(TextGrid grid) {
        TextGrid.Cell start;
        if (this.size() < 2) {
            return 1;
        }
        TextGrid workGrid = TextGrid.makeSameSizeAs(grid);
        grid.copyCellsTo(this, workGrid);
        TextGrid.Cell previous = start = (TextGrid.Cell)this.get(0);
        TextGrid.Cell cell = null;
        CellSet nextCells = workGrid.followCell(previous);
        if (nextCells.size() == 0) {
            return 1;
        }
        cell = (TextGrid.Cell)nextCells.get(0);
        while (!cell.equals(start)) {
            nextCells = workGrid.followCell(cell, previous);
            if (nextCells.size() == 0) {
                return 1;
            }
            if (nextCells.size() == 1) {
                previous = cell;
                cell = (TextGrid.Cell)nextCells.get(0);
                continue;
            }
            if (nextCells.size() <= 1) continue;
            return 4;
        }
        return 0;
    }

    private int getTypeAccordingToFillMethod(TextGrid grid) {
        if (this.size() == 0) {
            return 1;
        }
        CellSet tempSet = CellSet.copyCellSet(this);
        tempSet.translate(-this.getMinX() + 1, -this.getMinY() + 1);
        TextGrid subGrid = grid.getSubGrid(this.getMinX() - 1, this.getMinY() - 1, this.getWidth() + 3, this.getHeight() + 3);
        AbstractionGrid abstraction = new AbstractionGrid(subGrid, tempSet);
        TextGrid temp = abstraction.getCopyOfInternalBuffer();
        Object cell1 = null;
        Object cell2 = null;
        int width = temp.getWidth();
        int height = temp.getHeight();
        TextGrid.Cell fillCell = null;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                TextGrid.Cell cCell = new TextGrid.Cell(temp, x, y);
                if (temp.isBlank(cCell)) {
                    fillCell = cCell;
                    break;
                }
                ++x;
            }
            ++y;
        }
        if (fillCell == null) {
            System.err.println("Unexpected error: fill method cannot fill anywhere");
            return 4;
        }
        temp.fillContinuousArea(fillCell, '*');
        if (temp.hasBlankCells()) {
            return 3;
        }
        return 1;
    }

    public void translate(int dx, int dy) {
        this.typeIsValid = false;
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cCell = (TextGrid.Cell)it.next();
            cCell.x += dx;
            cCell.y += dy;
        }
    }

    public TextGrid.Cell find(TextGrid.Cell cell) {
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cCell = (TextGrid.Cell)it.next();
            if (!cCell.equals(cell)) continue;
            return cCell;
        }
        return null;
    }

    public boolean contains(TextGrid.Cell cell) {
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cCell = (TextGrid.Cell)it.next();
            if (!cCell.equals(cell)) continue;
            return true;
        }
        return false;
    }

    public void addSet(CellSet set) {
        this.typeIsValid = false;
        this.addAll(set);
    }

    public boolean hasCommonCells(CellSet set) {
        CellSet otherSet = this.size() < set.size() ? set : this;
        Iterator it = this.size() < set.size() ? ((AbstractList)this).iterator() : ((AbstractList)set).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            if (!otherSet.contains(cell)) continue;
            return true;
        }
        return false;
    }

    public TextGrid.Cell find(int x, int y) {
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cCell = (TextGrid.Cell)it.next();
            if (cCell.x != x || cCell.y != y) continue;
            return cCell;
        }
        return null;
    }

    public CellSet getFilledEquivalent(TextGrid textGrid) {
        if (this.getType(textGrid) == 1) {
            return new CellSet((Collection)this);
        }
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        TextGrid.Cell cell = null;
        boolean finished = false;
        int y = 0;
        while (y < grid.getHeight() && !finished) {
            int x = 0;
            while (x < grid.getWidth() && !finished) {
                cell = new TextGrid.Cell(grid, x, y);
                if (!grid.isBlank(cell) && grid.isBlank(cell.getEast()) && grid.isBlank(cell.getWest())) {
                    finished = true;
                }
                ++x;
            }
            ++y;
        }
        if (cell != null) {
            if (grid.isOutOfBounds(cell = cell.getEast())) {
                return new CellSet((Collection)this);
            }
            grid.fillContinuousArea(cell, '*');
            return grid.getAllNonBlank();
        }
        System.err.println("Unexpected error, cannot find the filled equivalent of CellSet");
        return null;
    }

    public TextGrid.Cell findCellNextTo(TextGrid.Cell cell) {
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cCell = (TextGrid.Cell)it.next();
            if (!cCell.isNextTo(cell)) continue;
            return cCell;
        }
        return null;
    }

    public CellSet findCellsNextTo(TextGrid.Cell cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell cannot be null");
        }
        CellSet set = new CellSet();
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cCell = (TextGrid.Cell)it.next();
            if (!cCell.isNextTo(cell)) continue;
            set.add(cCell);
        }
        return set;
    }

    public void appendSet(CellSet set) {
        this.typeIsValid = false;
        Iterator it = ((AbstractList)set).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            if (this.find(cell) != null) continue;
            this.add(cell);
        }
    }

    public void subtractSet(CellSet set) {
        this.typeIsValid = false;
        Iterator it = ((AbstractList)set).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            TextGrid.Cell thisCell = this.find(cell);
            if (thisCell == null) continue;
            this.remove(thisCell);
        }
    }

    public int getWidth() {
        return this.getMaxX() - this.getMinX();
    }

    public int getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public int getMaxX() {
        int result = 0;
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            if (cell.x <= result) continue;
            result = cell.x;
        }
        return result;
    }

    public int getMinX() {
        int result = Integer.MAX_VALUE;
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            if (cell.x >= result) continue;
            result = cell.x;
        }
        return result;
    }

    public int getMaxY() {
        int result = 0;
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            if (cell.y <= result) continue;
            result = cell.y;
        }
        return result;
    }

    public int getMinY() {
        int result = Integer.MAX_VALUE;
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            if (cell.y >= result) continue;
            result = cell.y;
        }
        return result;
    }

    public boolean remove(Object o) {
        if (!(o instanceof TextGrid.Cell)) {
            return false;
        }
        this.typeIsValid = false;
        TextGrid.Cell cell = (TextGrid.Cell)o;
        if ((cell = this.find(cell)) != null) {
            return super.remove(cell);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CellSet)) {
            return false;
        }
        CellSet set = (CellSet)o;
        if (this.size() != set.size()) {
            return false;
        }
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            if (set.contains(cell)) continue;
            return false;
        }
        return true;
    }

    public void removeDuplicateCells() {
        ArrayList<TextGrid.Cell> uniqueCells = new ArrayList<TextGrid.Cell>();
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            boolean isOriginal = true;
            Iterator uniquesIt = ((AbstractList)uniqueCells).iterator();
            while (uniquesIt.hasNext()) {
                TextGrid.Cell uniqueCell = (TextGrid.Cell)uniquesIt.next();
                if (!cell.equals(uniqueCell)) continue;
                isOriginal = false;
            }
            if (!isOriginal) continue;
            uniqueCells.add(cell);
        }
        this.clear();
        this.addAll(uniqueCells);
    }

    public static ArrayList removeDuplicateSets(ArrayList list) {
        ArrayList<CellSet> uniqueSets = new ArrayList<CellSet>();
        Iterator it = ((AbstractList)list).iterator();
        while (it.hasNext()) {
            CellSet set = (CellSet)it.next();
            boolean isOriginal = true;
            Iterator uniquesIt = ((AbstractList)uniqueSets).iterator();
            while (uniquesIt.hasNext()) {
                CellSet uniqueSet = (CellSet)uniquesIt.next();
                if (!set.equals(uniqueSet)) continue;
                isOriginal = false;
            }
            if (!isOriginal) continue;
            uniqueSets.add(set);
        }
        return uniqueSets;
    }

    public ArrayList breakIntoDistinctBoundaries(TextGrid grid) {
        AbstractionGrid temp = new AbstractionGrid(grid, this);
        ArrayList result = temp.getDistinctShapes();
        return result;
    }

    public ArrayList breakIntoDistinctBoundaries() {
        ArrayList<CellSet> result = new ArrayList<CellSet>();
        TextGrid boundaryGrid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        boundaryGrid.fillCellsWith(this, '*');
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell cell = (TextGrid.Cell)it.next();
            if (boundaryGrid.isBlank(cell.x, cell.y)) continue;
            CellSet boundarySet = boundaryGrid.fillContinuousArea(cell.x, cell.y, ' ');
            result.add(boundarySet);
        }
        return result;
    }

    public ArrayList breakTrulyMixedBoundaries(TextGrid grid) {
        CellSet set;
        ArrayList<CellSet> result = new ArrayList<CellSet>();
        CellSet visitedEnds = new CellSet();
        TextGrid workGrid = TextGrid.makeSameSizeAs(grid);
        grid.copyCellsTo(this, workGrid);
        Iterator it = ((AbstractList)this).iterator();
        while (it.hasNext()) {
            TextGrid.Cell start = (TextGrid.Cell)it.next();
            if (!workGrid.isLinesEnd(start) || visitedEnds.contains(start)) continue;
            set = new CellSet();
            set.add(start);
            TextGrid.Cell previous = start;
            TextGrid.Cell cell = null;
            CellSet nextCells = workGrid.followCell(previous);
            if (nextCells.size() == 0) {
                throw new IllegalArgumentException("This shape is either open but multipart or has only one cell, and cannot be processed by this method");
            }
            cell = (TextGrid.Cell)nextCells.get(0);
            set.add(cell);
            boolean finished = false;
            if (workGrid.isLinesEnd(cell)) {
                visitedEnds.add(cell);
                finished = true;
            }
            while (!finished) {
                nextCells = workGrid.followCell(cell, previous);
                if (nextCells.size() == 1) {
                    set.add(cell);
                    previous = cell;
                    cell = (TextGrid.Cell)nextCells.get(0);
                    if (!workGrid.isLinesEnd(cell)) continue;
                    visitedEnds.add(cell);
                    finished = true;
                    continue;
                }
                if (nextCells.size() <= 1) continue;
                finished = true;
            }
            result.add(set);
        }
        CellSet whatsLeft = new CellSet((Collection)this);
        it = ((AbstractList)result).iterator();
        while (it.hasNext()) {
            set = (CellSet)it.next();
            whatsLeft.subtractSet(set);
        }
        result.add(whatsLeft);
        return result;
    }

    public TextGrid makeIntoGrid() {
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        return grid;
    }

    public CellSet makeScaledOneThirdEquivalent() {
        TextGrid gridBig = this.makeIntoGrid();
        gridBig.fillCellsWith(this, '*');
        TextGrid gridSmall = new TextGrid((this.getMaxX() + 2) / 3, (this.getMaxY() + 2) / 3);
        int y = 0;
        while (y < gridBig.getHeight()) {
            int x = 0;
            while (x < gridBig.getWidth()) {
                TextGrid.Cell cell = new TextGrid.Cell(gridBig, x, y);
                if (!gridBig.isBlank(cell)) {
                    gridSmall.set(x / 3, y / 3, '*');
                }
                ++x;
            }
            ++y;
        }
        return gridSmall.getAllNonBlank();
    }
}

