/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualTester {
    private static final String HTMLReportName = "test_suite";

    public static void main(String[] args) {
        VisualTester tester = new VisualTester();
        String textDir = "tests/text";
        String reportDir = "tests/images";
        File textDirObj = new File(textDir);
        ArrayList<File> textFiles = new ArrayList<File>(Arrays.asList(textDirObj.listFiles()));
        Iterator<File> it = textFiles.iterator();
        while (it.hasNext()) {
            if (it.next().toString().matches(".+\\.txt$")) continue;
            it.remove();
        }
        tester.createHTMLTestReport(textFiles, reportDir, HTMLReportName);
        System.out.println("Tests completed");
    }

    public boolean createHTMLTestReport(ArrayList<File> textFiles, String reportDir, String reportName) {
        ConversionOptions options = new ConversionOptions();
        String reportFilename = String.valueOf(reportDir) + "/" + reportName + ".html";
        if (!new File(reportDir).exists()) {
            File dir = new File(reportDir);
            dir.mkdir();
        }
        PrintWriter s = null;
        try {
            s = new PrintWriter(new FileWriter(reportFilename));
        }
        catch (IOException e) {
            System.err.println("Cannot open file " + reportFilename + " for writing:");
            e.printStackTrace();
            return false;
        }
        s.println("<html><body>");
        s.println("<h1>ditaa test suite</h1>");
        s.println("<h2>generated on: " + Calendar.getInstance().getTime() + "</h2>");
        for (File textFile : textFiles) {
            long b;
            TextGrid grid = new TextGrid();
            File toFile = new File(String.valueOf(reportDir) + File.separator + textFile.getName() + ".png");
            long a = System.nanoTime();
            try {
                System.out.println("Rendering " + textFile + " to " + toFile);
                grid.loadFrom(textFile.toString());
                Diagram diagram = new Diagram(grid, options);
                RenderedImage image = new BitmapRenderer().renderToImage(diagram, options.renderingOptions);
                b = System.nanoTime();
                System.out.println("Done in " + Math.round((double)(b - a) / 1.0E7) + "msec");
                try {
                    File file = new File(toFile.getAbsolutePath());
                    ImageIO.write(image, "png", file);
                }
                catch (IOException e) {
                    System.err.println("Error: Cannot write to file " + toFile);
                    System.exit(1);
                }
            }
            catch (Exception e) {
                s.println("<b>!!! Failed to render: " + textFile + " !!!</b>");
                s.println("<pre>\n" + grid.getDebugString() + "\n</pre>");
                s.println(e.getMessage());
                s.println("<hr />");
                s.flush();
                System.err.println("!!! Failed to render: " + textFile + " !!!");
                e.printStackTrace(System.err);
                continue;
            }
            s.println(this.makeReportTable(textFile.getName(), grid, toFile.getName(), b - a));
            s.println("<hr />");
            s.flush();
        }
        s.println("</body></html>");
        s.flush();
        s.close();
        System.out.println("Wrote HTML report to " + new File(reportFilename).getAbsolutePath());
        return true;
    }

    private String makeReportTable(String gridURI, TextGrid grid, String imageURI, long time) {
        StringBuffer buffer = new StringBuffer("<center><table border=\"0\">");
        buffer.append("<th colspan=\"2\"><h3>" + gridURI + " (" + Math.round((double)time / 1.0E7) + "msec)</h3></th>");
        buffer.append("<tr><td><pre>\n" + grid.getDebugString() + "\n</pre></td>");
        buffer.append("<td><img border=\"0\" src=\"" + imageURI + "\"</td></tr>");
        buffer.append("</table></center>");
        return buffer.toString();
    }
}

