/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.IOutputSegment;
import au.id.jericho.lib.html.Source;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class OutputDocument {
    private String sourceText;
    private ArrayList outputSegments = new ArrayList();

    public OutputDocument(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.sourceText = string;
    }

    public OutputDocument(Source source) {
        this(source.getSourceText());
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public void add(IOutputSegment iOutputSegment) {
        this.outputSegments.add(iOutputSegment);
    }

    public void output(Writer writer) throws IOException {
        if (this.outputSegments.isEmpty()) {
            writer.write(this.sourceText);
            return;
        }
        int n = 0;
        Collections.sort(this.outputSegments, IOutputSegment.COMPARATOR);
        Iterator iterator = this.outputSegments.iterator();
        while (iterator.hasNext()) {
            IOutputSegment iOutputSegment = (IOutputSegment)iterator.next();
            if (iOutputSegment.getBegin() > n) {
                writer.write(this.sourceText.substring(n, iOutputSegment.getBegin()));
            }
            iOutputSegment.output(writer);
            n = iOutputSegment.getEnd();
        }
        if (n < this.sourceText.length()) {
            writer.write(this.sourceText.substring(n));
        }
        writer.close();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter((int)((double)this.sourceText.length() * 1.5));
        try {
            this.output(stringWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringWriter.toString();
    }
}

