/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.SpecialTag;
import au.id.jericho.lib.html.StartTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Segment {
    int begin;
    int end;
    Source source;
    private static final String WHITESPACE = " \n\r\t";

    public Segment(Source source, int begin, int end) {
        this(begin, end);
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.source = source;
    }

    Segment(int begin, int end) {
        if (begin == -1 || end == -1 || begin > end) {
            throw new IllegalArgumentException();
        }
        this.begin = begin;
        this.end = end;
    }

    Segment() {
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)object;
        return segment.begin == this.begin && segment.end == this.end && segment.source == this.source;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    public final int length() {
        return this.end - this.begin;
    }

    public final boolean encloses(Segment segment) {
        return this.begin <= segment.begin && this.end >= segment.end;
    }

    public final boolean encloses(int pos) {
        return this.begin <= pos && pos < this.end;
    }

    public boolean isComment() {
        return false;
    }

    public String getSourceText() {
        return this.source.getSourceText().substring(this.begin, this.end);
    }

    public final String getSourceTextNoWhitespace() {
        StringBuffer sb = new StringBuffer();
        int i = this.begin;
        boolean lastWasWhitespace = true;
        boolean isWhitespace = false;
        while (i < this.end) {
            char c = this.source.getSourceText().charAt(i++);
            isWhitespace = Segment.isWhiteSpace(c);
            if (isWhitespace) {
                if (!lastWasWhitespace) {
                    sb.append(' ');
                }
            } else {
                sb.append(c);
            }
            lastWasWhitespace = isWhitespace;
        }
        if (isWhitespace) {
            sb.setLength(Math.max(0, sb.length() - 1));
        }
        return sb.toString();
    }

    public final List findWords() {
        ArrayList<Segment> words = new ArrayList<Segment>();
        int wordBegin = -1;
        int i = this.begin;
        while (i < this.end) {
            if (Segment.isWhiteSpace(this.source.getSourceText().charAt(i))) {
                if (wordBegin != -1) {
                    words.add(new Segment(this.source, wordBegin, i));
                    wordBegin = -1;
                }
            } else if (wordBegin == -1) {
                wordBegin = i;
            }
            ++i;
        }
        if (wordBegin != -1) {
            words.add(new Segment(this.source, wordBegin, this.end));
        }
        return words;
    }

    public List findAllStartTags() {
        return this.findAllStartTags(null);
    }

    public List findAllStartTags(String name) {
        StartTag startTag;
        if (name != null) {
            name = name.toLowerCase();
        }
        if ((startTag = this.findNextStartTag(this.begin, name)) == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartTag> list = new ArrayList<StartTag>();
        do {
            list.add(startTag);
        } while ((startTag = this.findNextStartTag(startTag.end, name)) != null);
        return list;
    }

    public List findAllComments() {
        return this.findAllStartTags(SpecialTag.COMMENT.getName());
    }

    public List findAllElements() {
        return this.findAllElements(null);
    }

    public List findAllElements(String name) {
        List startTags;
        if (name != null) {
            name = name.toLowerCase();
        }
        if ((startTags = this.findAllStartTags(name)).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> elements = new ArrayList<Element>(startTags.size());
        Iterator i = startTags.iterator();
        while (i.hasNext()) {
            StartTag startTag = (StartTag)i.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            elements.add(element);
        }
        return elements;
    }

    public List findAllCharacterReferences() {
        CharacterReference characterReference = this.findNextCharacterReference(this.begin);
        if (characterReference == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CharacterReference> list = new ArrayList<CharacterReference>();
        do {
            list.add(characterReference);
        } while ((characterReference = this.findNextCharacterReference(characterReference.end)) != null);
        return list;
    }

    public FormFields findFormFields() {
        return FormFields.construct(this);
    }

    public Attributes parseAttributes() {
        return this.source.parseAttributes(this.begin, this.end);
    }

    public void ignoreWhenParsing() {
        this.source.ignoreWhenParsing(this.begin, this.end);
    }

    public static final boolean isWhiteSpace(char c) {
        return WHITESPACE.indexOf(c) != -1;
    }

    public String toString() {
        return "(" + this.begin + ',' + this.end + ')';
    }

    static boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_' || c == ':';
    }

    static boolean isIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':';
    }

    private StartTag findNextStartTag(int pos, String name) {
        StartTag startTag = this.source.findNextStartTag(pos, name);
        if (startTag == null || startTag.end > this.end) {
            return null;
        }
        return startTag;
    }

    private CharacterReference findNextCharacterReference(int pos) {
        CharacterReference characterReference = this.source.findNextCharacterReference(pos);
        if (characterReference == null || characterReference.end > this.end) {
            return null;
        }
        return characterReference;
    }
}

