/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    public static String makeTargetPathname(String string, String string2, boolean bl) {
        return FileUtils.makeTargetPathname(string, string2, "", bl);
    }

    public static String makeTargetPathname(String string, String string2, String string3, boolean bl) {
        File file = new File(string);
        String string4 = "";
        if (file.getParentFile() != null && !(string4 = file.getParentFile().getAbsolutePath()).endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        String string5 = FileUtils.getBaseName(file.getName());
        String string6 = string4 + string5 + string3 + "." + string2;
        if (new File(string6).exists() && !bl) {
            string6 = FileUtils.makeAlternativePathname(string6);
        }
        return string6;
    }

    public static String makeAlternativePathname(String string) {
        int n = 100;
        for (int i = 2; i <= n; ++i) {
            String string2 = FileUtils.getBaseName(string) + "_" + i;
            String string3 = FileUtils.getExtension(string);
            if (string3 != null) {
                string2 = string2 + "." + string3;
            }
            if (new File(string2).exists()) continue;
            return string2;
        }
        return null;
    }

    public static String getExtension(String string) {
        if (string.lastIndexOf(46) == -1) {
            return null;
        }
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String getBaseName(String string) {
        if (string.lastIndexOf(46) == -1) {
            return string;
        }
        return string.substring(0, string.lastIndexOf(46));
    }

    public static String readFile(File file) throws IOException {
        return FileUtils.readFile(file, null);
    }

    public static String readFile(File file, String string) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        if (n < byArray.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)fileInputStream).close();
        if (string == null) {
            return new String(byArray);
        }
        return new String(byArray, string);
    }

    public static void main(String[] stringArray) {
        System.out.println(FileUtils.makeTargetPathname("C:\\Files\\papar.txt", "jpg", false));
        System.out.println(FileUtils.makeTargetPathname("C:\\Files\\papar", "jpg", false));
        System.out.println(FileUtils.makeTargetPathname("papar.txt", "jpg", false));
        System.out.println(FileUtils.makeTargetPathname("/home/sideris/tsourekia/papar.txt", "jpg", false));
        System.out.println(FileUtils.makeTargetPathname("D:\\diagram.max", "jpg", false));
        System.out.println(FileUtils.makeAlternativePathname("C:\\Files\\papar.txt"));
        System.out.println(FileUtils.makeAlternativePathname("C:\\Files\\papar"));
        System.out.println(FileUtils.getExtension("pipi.jpeg"));
        System.out.println(FileUtils.getExtension("pipi"));
    }
}

