/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.FormControlType;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;

public final class FormField {
    private String name;
    private int userValueCount = 0;
    private boolean allowsMultipleValues = false;
    private LinkedHashSet predefinedValues = null;
    private int position;
    private transient FormControlType firstEncounteredFormControlType = null;
    private transient boolean updateable = false;
    static Comparator COMPARATOR = new PositionComparator();

    FormField(String name, int position, FormControlType formControlType) {
        this.name = name;
        this.position = position;
        this.firstEncounteredFormControlType = formControlType;
        this.updateable = true;
    }

    public String getName() {
        return this.name;
    }

    public int getUserValueCount() {
        return this.userValueCount;
    }

    public boolean allowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public Collection getPredefinedValues() {
        return this.predefinedValues;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Field: ").append(this.name).append(", UserValueCount=").append(this.userValueCount).append(", AllowsMultipleValues=").append(this.allowsMultipleValues);
        if (this.predefinedValues != null) {
            Iterator i = this.predefinedValues.iterator();
            while (i.hasNext()) {
                sb.append("\nPredefinedValue: ");
                sb.append(i.next());
            }
        }
        sb.append("\n\n");
        return sb.toString();
    }

    void setLowerPosition(int position) {
        if (!this.updateable) {
            throw new NoLongerUpdateableException();
        }
        if (position < this.position) {
            this.position = position;
        }
    }

    void incrementUserValueCount() {
        ++this.userValueCount;
    }

    void addPredefinedValue(String predefinedValue) {
        if (!this.updateable) {
            throw new NoLongerUpdateableException();
        }
        if (this.predefinedValues == null) {
            this.predefinedValues = new LinkedHashSet();
        }
        this.predefinedValues.add(predefinedValue);
    }

    void setMultipleValues() {
        if (!this.updateable) {
            throw new NoLongerUpdateableException();
        }
        this.allowsMultipleValues = true;
    }

    void setMultipleValues(FormControlType formControlType) {
        if (!this.updateable) {
            throw new NoLongerUpdateableException();
        }
        if (!this.allowsMultipleValues) {
            this.allowsMultipleValues = this.calculateMultipleValues(formControlType);
        }
    }

    private boolean calculateMultipleValues(FormControlType formControlType) {
        if (this.userValueCount > 0 || formControlType.allowsMultipleValues() || this.firstEncounteredFormControlType.allowsMultipleValues()) {
            return true;
        }
        if (formControlType == this.firstEncounteredFormControlType) {
            return false;
        }
        return !formControlType.isSubmit() || !this.firstEncounteredFormControlType.isSubmit();
    }

    void merge(FormField formField) {
        this.updateable = false;
        formField.updateable = false;
        if (formField.userValueCount > this.userValueCount) {
            this.userValueCount = formField.userValueCount;
        }
        boolean bl = this.allowsMultipleValues = this.allowsMultipleValues || formField.allowsMultipleValues;
        if (this.predefinedValues == null) {
            this.predefinedValues = formField.predefinedValues;
        } else if (formField.predefinedValues != null) {
            Iterator i = formField.getPredefinedValues().iterator();
            while (i.hasNext()) {
                this.predefinedValues.add(i.next());
            }
        }
    }

    private static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof FormField) || !(o2 instanceof FormField)) {
                throw new ClassCastException();
            }
            FormField formField1 = (FormField)o1;
            FormField formField2 = (FormField)o2;
            if (formField1.position < formField2.position) {
                return -1;
            }
            if (formField1.position > formField2.position) {
                return 1;
            }
            return formField1.name.compareTo(formField2.name);
        }
    }

    private static class NoLongerUpdateableException
    extends RuntimeException {
        public NoLongerUpdateableException() {
            super("Internal Error: FormField objects are no longer updateable after merge or deserialisation");
        }
    }
}

