/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.stathissideris.ascii2image.core.ConfigurationParser;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.core.RenderingOptions;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.xml.sax.SAXException;

public class ConversionOptions {
    public ProcessingOptions processingOptions = new ProcessingOptions();
    public RenderingOptions renderingOptions = new RenderingOptions();

    public void setDebug(boolean bl) {
        this.processingOptions.setPrintDebugOutput(bl);
        this.renderingOptions.setRenderDebugLines(bl);
    }

    public ConversionOptions() {
    }

    public ConversionOptions(CommandLine commandLine) throws UnsupportedEncodingException {
        Object object;
        this.processingOptions.setVerbose(commandLine.hasOption("verbose"));
        this.renderingOptions.setDropShadows(!commandLine.hasOption("no-shadows"));
        this.setDebug(commandLine.hasOption("debug"));
        this.processingOptions.setOverwriteFiles(commandLine.hasOption("overwrite"));
        if (commandLine.hasOption("scale")) {
            object = Float.valueOf(Float.parseFloat(commandLine.getOptionValue("scale")));
            this.renderingOptions.setScale(((Float)object).floatValue());
        }
        this.processingOptions.setAllCornersAreRound(commandLine.hasOption("round-corners"));
        this.processingOptions.setPerformSeparationOfCommonEdges(!commandLine.hasOption("no-separation"));
        this.renderingOptions.setAntialias(!commandLine.hasOption("no-antialias"));
        if (commandLine.hasOption("tabs")) {
            object = Integer.parseInt(commandLine.getOptionValue("tabs"));
            int n = (Integer)object;
            if (n < 0) {
                n = 0;
            }
            this.processingOptions.setTabSize(n);
        }
        if ((object = commandLine.getOptionValue("encoding")) != null) {
            new String(new byte[2], (String)object);
            this.processingOptions.setCharacterEncoding((String)object);
        }
        ConfigurationParser configurationParser = new ConfigurationParser();
        try {
            for (Option option : commandLine.getOptions()) {
                if (!option.getLongOpt().equals("config")) continue;
                String string = option.getValue();
                System.out.println("Parsing configuration file " + string);
                File file = new File(string);
                if (file.exists()) {
                    configurationParser.parseFile(file);
                    HashMap<String, CustomShapeDefinition> hashMap = configurationParser.getShapeDefinitionsHash();
                    this.processingOptions.putAllInCustomShapes(hashMap);
                    continue;
                }
                System.err.println("File " + file + " does not exist, skipping");
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

